<?php
namespace Pochipp;

defined( 'ABSPATH' ) || exit;

/**
 * Creators API 未設定の通知（PA-API設定済みユーザー向け）
 */
add_action( 'admin_notices', function() {
	$post_type = \POCHIPP::get_sanitized_data( $_GET, 'post_type', 'text' );
	$page      = \POCHIPP::get_sanitized_data( $_GET, 'page', 'text' );

	// ポチップ設定ページのみで表示
	if ( \POCHIPP::POST_TYPE_SLUG !== $post_type || 'pochipp_settings' !== $page ) {
		return;
	}

	// PA-API が設定されていない場合は表示しない
	$access_key = \POCHIPP::get_setting( 'amazon_access_key' );
	$secret_key = \POCHIPP::get_setting( 'amazon_secret_key' );
	if ( ! $access_key || ! $secret_key ) {
		return;
	}

	// Creators API が設定済みなら表示しない
	$client_id     = \POCHIPP::get_setting( 'amazon_creators_client_id' );
	$client_secret = \POCHIPP::get_setting( 'amazon_creators_client_secret' );
	if ( $client_id && $client_secret ) {
		return;
	}

	$amazon_setting_url = admin_url( 'edit.php?post_type=pochipps&page=pochipp_settings&tab=amazon' );
	?>
	<div class="notice notice-warning">
		<p>
			<strong>Pochipp:</strong> 2025年1月30日以降、PA-API経由での検索が制限されます。
			<a href="https://pochipp.com/6079/" target="_blank" rel="noopener noreferrer">こちらのページ</a>を確認の上、Creators APIの設定を行ってください。
		</p>
	</div>
	<?php
} );
