<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://punkode.it
 * @since      1.0.0
 *
 * @package    Pk_Inexpress
 */

// If uninstall not called from WordPress, then exit.
if (! defined('WP_UNINSTALL_PLUGIN')) {
	exit;
}

// List of options to delete.
$pkinex_options_to_delete = array(
	'pkinex_id_name',
	'pkinex_service_source',
	'pkinex_service_target',
	'pkinex_source_url',
	'pkinex_source_type',
	'pkinex_xml_text',
);

// Delete all plugin options.
foreach ($pkinex_options_to_delete as $pkinex_opt) {
	delete_option($pkinex_opt);
}
