<?php
// EN: If this file is called directly, abort.
// IT: Se questo file viene chiamato direttamente, interrompi.
if (! defined('ABSPATH')) exit; // Exit

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://punkode.it
 * @since             1.1.6
 * @package           Pk_Inexpress
 *
 * @wordpress-plugin
 * Plugin Name:       PK InExPress
 * Plugin URI:        https://punkode.it/inexpress
 * Description:       Quick importer from management software (CRMs) to specific WordPress themes.
 * Version:           1.1.6
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Requires WP: 6.0
 * Tested up to: 6.8
 * Author:            punkode
 * Author URI:        https://punkode.it/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       pk-inexpress
 * Domain Path:       /languages
 */

if (! function_exists('pkinex_freemius')) {
    // Create a helper function for easy SDK access.
    function pkinex_freemius()
    {
        global $pkinex_freemius;

        if (! isset($pkinex_freemius)) {
            // Include Freemius SDK.
            require_once dirname(__FILE__) . '/vendor/freemius/start.php';
            $pkinex_freemius = fs_dynamic_init(array(
                'id'                  => '20321',
                'slug'                => 'pk-inexpress',
                'type'                => 'plugin',
                'public_key'          => 'pk_f036b4113e3666047b62b5a4f0b13',
                'is_premium'          => false,
                'has_addons'          => true,
                'has_paid_plans'      => true,
                'menu'                => array(
                    'slug'           => 'pk-inexpress',
                ),
            ));
        }

        return $pkinex_freemius;
    }

    // Init Freemius.
    pkinex_freemius();
    // Signal that SDK was initiated.
    do_action('pkinex_freemius_loaded');
}
// -------------------------------------------------------------
// EN: Main constants
// IT: Costanti principali
// -------------------------------------------------------------
if (! defined('PKINEX_INEXPRESS_VERSION')) {
    define('PKINEX_INEXPRESS_VERSION', '1.1.6');
}
if (! defined('PKINEX_INEXPRESS_DIR')) {
    define('PKINEX_INEXPRESS_DIR', plugin_dir_path(__FILE__));
}

if (! defined('PKINEX_INEXPRESS_FILE')) {
    define('PKINEX_INEXPRESS_FILE', __FILE__);
}



/**
 * EN: Check for minimum PHP and WordPress version compatibility.
 * IT: Controlla la compatibilità minima di PHP e WordPress.
 */

function pkinex_check_compatibility()
{
    $min_php = '7.4';
    $min_wp  = '5.0';

    // EN: Check PHP version
    // IT: Controlla la versione di PHP
    if (version_compare(PHP_VERSION, $min_php, '<')) {
        deactivate_plugins(plugin_basename(__FILE__));

        wp_die(
            sprintf(
                /* translators: 1: required PHP version, 2: current PHP version */
                esc_html__('PKINEX_Inexpress requires PHP %1$s or higher. Your current version is %2$s.', 'pk-inexpress'),
                esc_html($min_php),
                esc_html(PHP_VERSION)
            )
        );
    }


    // EN: Check WordPress version
    // IT: Controlla la versione di WordPress
    global $wp_version;
    if (version_compare($wp_version, $min_wp, '<')) {
        deactivate_plugins(plugin_basename(__FILE__));

        wp_die(
            sprintf(
                /* translators: 1: required WordPress version, 2: current WordPress version */
                esc_html__('PK_Inexpress requires WordPress %1$s or higher. Your current version is %2$s.', 'pk-inexpress'),
                esc_html($min_wp),
                esc_html($wp_version)
            )
        );
    }
}

// -------------------------------------------------------------
// EN: Autoloader
// IT: Inizializzazione del loader delle classi
//

// loader class
require_once PKINEX_INEXPRESS_DIR . 'includes/class-pkinex-autoloader.php';

// Init autoloader
// Init autoloader
$pkinex_autoloader = new PKINEX_Autoloader();
$pkinex_autoloader->pkinex_register();


// -------------------------------------------------------------
// EN: Activation / Deactivation
// IT: Attivazione / Disattivazione
// -------------------------------------------------------------
function pkinex_activate()
{
    require_once PKINEX_INEXPRESS_DIR . 'includes/class-pkinex-activator.php';
    PKINEX_Activator::pkinex_activate();
}
function pkinex_deactivate()
{
    require_once PKINEX_INEXPRESS_DIR . 'includes/class-pkinex-deactivator.php';
    PKINEX_Deactivator::pkinex_deactivate();
}
register_activation_hook(__FILE__, 'pkinex_activate');
register_deactivation_hook(__FILE__, 'pkinex_deactivate');


// -------------------------------------------------------------
// EN: Plugin initialization
// IT: Inizializzazione del plugin
// -------------------------------------------------------------


function pkinex_init()
{
    // EN: Load free admin features
    // IT: Carica le funzionalità admin (free)
    require_once PKINEX_INEXPRESS_DIR . 'admin/pkinex-admin-init.php';

    // Try to instantiate core plugin class if available.
    // If the autoloader is active, the class may be loaded automatically.
    if (class_exists('PKINEX_Inexpress')) {
        // Create a global reference if you need access elsewhere
        global $pkinex_inexpress;
        $pkinex_inexpress = new PKINEX_Inexpress();
    } else {
        // Optional: require the file explicitly if not autoloaded
        $core_file = PKINEX_INEXPRESS_DIR . 'includes/class-pkinex-inexpress.php';
        if (file_exists($core_file)) {
            require_once $core_file;
            if (class_exists('PKINEX_Inexpress')) {
                global $pkinex_inexpress;
                $pkinex_inexpress = new PKINEX_Inexpress();
            }
        }
    }
    // 👇 Dillo al mondo (e al Pro)
    do_action('pkinex_free_ready');
}
add_action('plugins_loaded', 'pkinex_init');
