<?php
// EN: If this file is called directly, abort.
// IT: Se questo file viene chiamato direttamente, interrompi.
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit
/**
 * ====================================================
 * FILE: delete-houzez.php
 * FROM → runner_houzez
 * TO → houzez
 * DESCRIPTION:
 * This class handles the removal of obsolete properties
 * from the 'property' custom post type based on a list
 * of legacy codes. Properties whose meta field matches
 * any of the provided codes will be moved to trash.
 *
 * Questa classe gestisce la rimozione degli immobili obsoleti
 * dal custom post type 'property', in base a un elenco di codici.
 * Gli immobili il cui campo meta corrisponde a uno dei codici
 * forniti verranno spostati nel cestino.
 * ====================================================
 */

class PKINEX_DeleteRealHouzez extends PKINEX_ManagerProcessor
{
    /** 
     * @var string[] List of IDs to delete, flipped for fast lookup (O(1))
     * @var string[] Elenco di ID da eliminare, ribaltato per lookup veloce (O(1))
     */
    private $list_id_delete;

    /**
     * @var string Name of the custom field that stores the code (e.g., 'realsoftware_codice')
     * @var string Nome del campo personalizzato che memorizza il codice (es. 'realsoftware_codice')
     */
    private $id_name;

    /**
     * Constructor
     * 
     * @param string $nomeCampoId        The meta field name to check (e.g., 'realsoftware_codice')
     * @param string[] $list_id_delete  Array of codes (strings) to be deleted
     *
     * Costruttore
     *
     * @param string $id_name        Il nome del campo meta da verificare (es. 'realsoftware_codice')
     * @param string[] $lista_id_da_eliminare  Array di codici (stringhe) da eliminare
     */

    public function __construct(string $id_name, array $list_id_delete)
    {
        parent::__construct(true); // load options if needed
        $this->id_name = $id_name;
        $this->list_id_delete = $list_id_delete;
    }




    /**
     * Removes all 'property' posts whose meta field matches one of the codes in the list.
     * Each matching post is moved to trash if not already there.
     *
     * Rimuove tutti i post di tipo 'property' il cui campo meta corrisponde a uno dei codici.
     * Ogni post trovato viene spostato nel cestino se non è già nel cestino.
     */
    public function pkinex_delete_real_houzez()
    {
      
        $n_delete_posts = $this->pkinex_delete_old_posts('property', $this->id_name, $this->list_id_delete);

        return $n_delete_posts;
    }
}
