<?php
// EN: If this file is called directly, abort.
// IT: Se questo file viene chiamato direttamente, interrompi.
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit
/**
 * Core plugin class: handles i18n and public-facing hooks
 *
 * @link       https://punkode.it
 * @since      1.0.0
 * @package    Pk_Inexpress
 * @subpackage Pk_Inexpress/includes
 */
class PKINEX_Inexpress {
    /**
     * Unique identifier for the plugin.
     * @var string
     */
    protected $plugin_name;

    /**
     * Plugin version.
     * @var string
     */
    protected $version;

    /**
     * Constructor: set name, version, and register hooks
     */
    public function __construct() {
        $this->plugin_name = 'pk-inexpress';
        $this->version     = 'PK_INEXPRESS_VERSION';

        $this->load_dependencies();
        $this->register_public_hooks();
    }

    /**
     * Load any required dependencies (if needed for public features)
     */
    private function load_dependencies() {
        // Require public class for enqueueing scripts/styles
        require_once PKINEX_INEXPRESS_DIR . 'public/class-pkinex-inexpress-public.php';
    }


    /**
     * Register hooks for public-facing side
     */
    private function register_public_hooks() {
        $public = new PKINEX_InexpressPublic($this->plugin_name, $this->version);
        add_action('wp_enqueue_scripts', array($public, 'enqueue_styles'));
        add_action('wp_enqueue_scripts', array($public, 'enqueue_scripts'));
    }

    /**
     * Get plugin version
     */
    public function get_version() {
        return $this->version;
    }

    /**
     * Get plugin name
     */
    public function get_plugin_name() {
        return $this->plugin_name;
    }
}

