# PKINEX_ManagerProcessor — Indice funzioni (schematico)

Sintesi per funzione: **nome → cosa fa → input → output/effetti**.  
Questa pagina è un promemoria rapido; mantenerla aggiornata quando il codice cambia.

---

- `__construct($load_options = true)`  
  Inizializza e (se richiesto) carica le opzioni da `pkinex_options`.  
  **In:** `bool $load_options` • **Out:** — • **Effetti:** popola `$this->options`.

- `pkinex_check_remote_url(string $url, int $timeout = 8)`  
  Verifica raggiungibilità URL (HEAD, fallback GET) e ritorna HTTP code oppure `WP_Error`.  
  **In:** URL, timeout • **Out:** `int|WP_Error` • **Effetti:** —.

- `pkinex_check_base_terms(string $taxonomy, array $terms): void`  
  Garantisce l’esistenza dei termini base di una tassonomia.  
  **In:** slug tassonomia, mappa `slug => name` • **Out:** — • **Effetti:** `wp_insert_term`.

- `pkinex_update_post_meta(int $post_id, string $meta_key, $value, string $type = 'string'): bool`  
  Aggiorna un meta con sanitizzazione per tipo (`string|int|bool|float`).  
  **In:** post_id, chiave, valore, tipo • **Out:** `bool` • **Effetti:** `update_post_meta`.

- `pkinex_assign_taxonomy_terms(int $post_id, string $taxonomy, $terms): void`  
  Assegna termini a un post (stringa singola, CSV o array; crea i termini se mancano).  
  **In:** post_id, tassonomia, termini • **Out:** — • **Effetti:** `wp_insert_term`, `wp_set_object_terms`.

- `pkinex_attach_images(array $images_urls, int $post_id): array`  
  Scarica e allega immagini (sideload), aggiorna `fave_property_images`, setta featured se mancante.  
  **In:** array URL, post_id • **Out:** `['ids'=>[], 'names'=>[]]` • **Effetti:** attachment media + meta.

- `pkinex_add_floor_plan(int $post_id, string $floorplan_url): bool`  
  Salva una planimetria in `floor_plans` se l’URL è raggiungibile.  
  **In:** post_id, URL • **Out:** `bool` • **Effetti:** `update_post_meta('floor_plans')`.

- `pkinex_assign_agent_post_by_name(int $post_id, string $related_post_type, string $search_name, string $meta_key, int $default_id): bool`  
  Trova un post correlato per **titolo esatto** (es. agente) e salva il suo ID in un meta scelto.  
  **In:** post_id, post_type, nome, meta_key, default_id • **Out:** `bool` • **Effetti:** `update_post_meta`.

- `pkinex_find_agent_by_line_id(int $post_id, $line_id, int $default_agent_id): void`  
  Risolve l’agente via `fave_agent_line_id` (raw e normalizzato) e applica **stile REAL**:  
  salva `fave_agents` **scalare** + `fave_agent_display_option='agent_info'` (pulisce `fave_property_agent`).  
  **In:** post_id, line_id, default_id • **Out:** — • **Effetti:** meta immobile aggiornati.

- `pkinex_add_additional_detail(int $post_id, string $title, string $value): void`  
  Aggiunge/aggiorna una riga in `fave_additional_features` (titolo/valore).  
  **In:** post_id, titolo, valore • **Out:** — • **Effetti:** `update_post_meta`.

- `pkinex_remove_additional_detail(int $post_id, string $title): void`  
  Rimuove una riga da `fave_additional_features` in base al titolo.  
  **In:** post_id, titolo • **Out:** — • **Effetti:** `update_post_meta`/`delete_post_meta`.

- `pkinex_save_meta_field(int $post_id, string $label, string $value): void`  
  Salva meta “etichettato” (`pkinex_<slug> = value`) e aggiorna indice aggregato `pkinex_specs`.  
  **In:** post_id, label, value • **Out:** — • **Effetti:** vari meta.

- `pkinex_add_single_feature(int $post_id, string $feature_name, string $taxonomy = 'property_feature'): void`  
  Assicura il termine “feature” e lo assegna (append).  
  **In:** post_id, nome feature, tassonomia • **Out:** — • **Effetti:** `wp_insert_term`, `wp_set_object_terms`.

- `pkinex_add_virtual_tour(int $post_id, string $virtual_tour_url): void`  
  Salva un iframe del tour virtuale in `fave_virtual_tour`.  
  **In:** post_id, URL • **Out:** — • **Effetti:** `update_post_meta`.

- `pkinex_update_taxonomy(int $post_id, string $tax, string $term): void`  
  Aggiorna una tassonomia **solo se** differente/mancante (crea il termine se serve).  
  **In:** post_id, tassonomia, termine • **Out:** — • **Effetti:** `wp_insert_term`, `wp_set_object_terms`.

- `pkinex_update_gallery(int $post_id, SimpleXMLElement $immobile): void`  
  Sincronizza galleria: aggiunge nuove immagini (da feed) e rimuove le non più presenti.  
  **In:** post_id, nodo XML • **Out:** — • **Effetti:** media + meta `fave_property_images`.

- `pkinex_update_plan(int $post_id, string $newUrl): void`  
  Aggiorna `floor_plans` solo se l’URL è cambiato e raggiungibile.  
  **In:** post_id, URL • **Out:** — • **Effetti:** `update_post_meta`.

- `pkinex_get_postid_bymeta(string $meta_key, string $meta_value)`  
  Trova un **property** per meta key/value e ritorna l’ID (o `false`).  
  **In:** meta_key, meta_value • **Out:** `int|false` • **Effetti:** —.

- `pkinex_update_meta(int $post_id, string $meta_key, $new_value): void`  
  Aggiorna un meta **solo se** il valore è cambiato.  
  **In:** post_id, chiave, nuovo valore • **Out:** — • **Effetti:** `update_post_meta`.

- `pkinex_delete_old_posts(string $post_type, string $id_name, $list_id_delete): int`  
  Cestina i post che matchano una lista di ID esterni (meta `id_name = codice`).  
  **In:** post_type, meta key id esterno, lista codici • **Out:** `int` (conteggio eliminati) • **Effetti:** `wp_trash_post`.

---

**Suggerimento:** Mantieni questo file in `docs/` e linkalo da `docs/README.md` come indice per lo sviluppo.
