# Houzez — come far comparire l’agente sugli immobili

**Principio chiave**  
Nel setup attuale, l’agente appare nel front‑end quando l’immobile ha *i meta giusti* nel *formato giusto*. Niente altro.

## Prerequisiti
- Esiste il CPT `houzez_agent` (gli agenti vanno creati prima dell’import).
- Dati minimi per ogni agente:
  - **REAL** → il *titolo* del post agente è il *nome esatto*.
  - **Miogest** → il post agente ha il meta `fave_agent_line_id` coerente (**solo cifre, senza zeri iniziali**).

## Da dove prendo il dato dal feed
- **REAL** → prendo il **nome agente** e cerco il `houzez_agent` per *titolo esatto*.
- **Miogest** → prendo il **line_id**, lo normalizzo (solo cifre, tolgo zeri a sinistra), e cerco nel meta `fave_agent_line_id` (accetto sia la forma “raw” sia la forma “normalizzata”).

## Cosa scrivere sull’immobile (minimo indispensabile)
- `fave_agents` → **ID agente come valore singolo (scalare)**.  
  Esempio corretto in DB: `meta_key=fave_agents` | `meta_value=150`  
  *(Non salvare array serializzati.)*
- `fave_agent_display_option` → `agent_info`.

> **Da evitare qui:** `fave_property_agent`. In questo setup fa comparire l’agente solo dopo aver premuto “Salva” in admin.

## Flusso mentale da ricordare
- **REAL** → “Ho il *nome* → trovo l’agente per *titolo esatto* → salvo `fave_agents` (scalare) + `fave_agent_display_option`.”
- **Miogest** → “Ho il *line_id* → *normalizzo* → trovo l’agente per `fave_agent_line_id` → salvo `fave_agents` (scalare) + `fave_agent_display_option`.”
- Se non trovo l’agente, uso un **fallback ID** deciso da me per evitare buchi.

## Anti‑pattern (cose da NON fare)
- Salvare `fave_agents` come **array** (serializzato) invece che *scalare*.
- Scrivere `fave_property_agent` (in questo ambiente porta al “si vede solo dopo Salva”).
- Fare “finalizzazioni” (update/clean cache) ripetute e sparse: se proprio servono, **una sola volta a fine immobile**.

## Debug lampo (checklist)
- Sul post *immobile* verifico:
  - `fave_agents` = **numero singolo** (es. `150`).
  - `fave_agent_display_option` = **`agent_info`**.
  - `fave_property_agent` **assente**.
- L’agente esiste come `houzez_agent` ed è **pubblicato**?
- (Miogest) il `houzez_agent` ha `fave_agent_line_id` corretto (solo cifre, senza zeri iniziali)?

## Finalizzazione opzionale (solo se cache “appiccicose”)
Se, nonostante tutto, l’agente non appare subito (es. per cache aggressive), fai **una sola** finalizzazione al termine dell’import dell’immobile: aggiorna `post_modified` e pulisci la cache oggetto. Nel tuo setup, quando `fave_agents` è *scalare*, in genere **non serve**.

---

### Nota sul formato
Questo file è in **Markdown** (`.md`). Puoi leggerlo/editarlo ovunque (IDE, GitHub, editor di testo) e tenerlo in `docs/agents-houzez.md` nel progetto.
