<?php
// EN: If this file is called directly, abort.
// IT: Se questo file viene chiamato direttamente, interrompi.
if (! defined('ABSPATH')) exit; // Exit
/*
 * FILE: dashboard.php
 * DESCRIPTION: Renders the main dashboard page of the PK InExpress plugin
 * FROM → admin-init.php (menu callback) | TO → none
 * FUNCTIONS: pkinex_render_dashboard_page() - outputs dashboard admin page HTML
 */

/**
 * EN: Renders the main dashboard page for the plugin admin area.
 * IT: Visualizza la pagina principale della dashboard dell'area admin del plugin.
 */
function pkinex_render_dashboard_page()
{
?>
    <div class="wrap" style="display: flex; gap: 20px; font-family: Arial, sans-serif;">

        <!-- MAIN CONTENT -->
        <main style="flex: 3; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 4px;">

            <!-- EN: Plugin title box -->
            <!-- IT: Box con il titolo del plugin -->
            <h1 style="border-bottom: 3px solid #0073aa; padding-bottom: 10px;">
                <?php echo esc_html__('PK InExPress Dashboard', 'pk-inexpress'); ?>
            </h1>

            <p><strong><?php echo esc_html__('Current Version:', 'pk-inexpress'); ?></strong> <?php echo esc_attr(PKINEX_INEXPRESS_VERSION) ?></p>

            <h2><?php echo esc_html__('Overview', 'pk-inexpress'); ?></h2>
            <p>
                <?php echo esc_html__(
                    'Pk InExPress is designed to connect management systems (CRMs) with WordPress themes.  
     We start with a real estate CRM to Houzez theme integration, but soon we will extend to other CRMs and other industry-specific themes.  
     Not limited to real estate: any sector that requires specific product or service import will be supported.  
     With a simple interface, you can: Insert the XML URL. The importer will automatically handle every meta, option, feature, taxonomy term, or agent related to the content.
    Ensure data is imported in a structured and reliable way, optimized for the chosen theme.',
                    'pk-inexpress'
                );

                echo ' ';

                echo esc_html__(
                    'This plugin follows WordPress best practices and is GPL-licensed.',
                    'pk-inexpress'
                ); ?>
            </p>
            <p><?php echo esc_html__('Minimum Requirements: WordPress 5.6+, PHP 7.4+', 'pk-inexpress'); ?></p>

            <!-- EN: Note about PRO version -->
            <!-- IT: Nota sulla versione PRO -->
            <p style="background: #f0f0f0; padding: 10px; border-left: 4px solid #0073aa; border-radius: 3px;">
                <?php echo esc_html__('Advanced scheduling features (Quick imports with cron) are available in the PRO version.', 'pk-inexpress'); ?>
            </p>

            <h2><?php echo esc_html__('Getting Started', 'pk-inexpress'); ?></h2>
            <ul>
                <li><?php echo esc_html__('Use the Quick Import tab to start importing XML data.', 'pk-inexpress'); ?></li>
                <li><?php echo esc_html__('Check the Support section for FAQs and troubleshooting.', 'pk-inexpress'); ?></li>
            </ul>

            <h2><?php echo esc_html__('Supported Imports', 'pk-inexpress'); ?></h2>
            <ul>
                <li><?php echo esc_html__('RealSoftware → Houzez (real estate sector)', 'pk-inexpress'); ?></li>
                <li><?php echo esc_html__('MioGest → Houzez (real estate sector)', 'pk-inexpress'); ?></li>
            </ul>

            <h2><?php echo esc_html__('Future Releases / Roadmap', 'pk-inexpress'); ?></h2>
            <p><?php echo esc_html__('Currently in development:', 'pk-inexpress'); ?></p>
            <ul>
                <li><?php echo esc_html__('RealSoftware → WP Residence', 'pk-inexpress'); ?></li>
                <li><?php echo esc_html__('Gestim → WP Residence', 'pk-inexpress'); ?></li>
                <li><?php echo esc_html__('Gestim → Houzez import', 'pk-inexpress'); ?></li>
            </ul>

        </main>

        <!-- SIDEBAR -->
        <aside style="flex: 1; background: #f9f9f9; padding: 20px; border: 1px solid #ddd; border-radius: 4px;">

            <h2><?php echo esc_html__('About Punkode', 'pk-inexpress'); ?></h2>
            <p>
                <?php echo esc_html__(
                    'Punkode is a team dedicated to software development, web applications, and websites.',
                    'pk-inexpress'
                ); ?>
            </p>
            <p><?php echo esc_html__('Team members: Gabriella Saia & Massimiliano Paradiso', 'pk-inexpress'); ?></p>

            <h3><?php echo esc_html__('Contact', 'pk-inexpress'); ?></h3>
            <p>
                <strong><?php echo esc_html__('Website:', 'pk-inexpress'); ?></strong><br>
                <a href="https://punkode.it/inexpress" target="_blank" rel="noopener noreferrer">punkode.it/inexpress</a>
            </p>
            <p>
                <strong><?php echo esc_html__('Email:', 'pk-inexpress'); ?></strong><br>
                <a href="mailto:info@punkode.it">info@punkode.it</a>
            </p>

        </aside>

    </div>
<?php
}
