jQuery(document).ready(function ($) {

    // riceve dalla localize
    var instructions = (typeof pkinex_vars !== "undefined" && pkinex_vars.instructions) ? pkinex_vars.instructions : {};
    var defaultText = (typeof pkinex_vars !== "undefined" && pkinex_vars.default_instruction) ? pkinex_vars.default_instruction : 'Select a source service to see instructions.';

    // Aggiorna l'area istruzioni in base al servizio sorgente selezionato
    function updateInstructions() {
        var src = $('#pkinex_service_source').val();
        var txt = instructions[src] || defaultText;
        $('#pkinex_instructions').html(txt);
    }

    // Chiamate iniziali
    updateInstructions();

    // Eventi
    $('#pkinex_service_source').on('change', updateInstructions);
    $('#pkinex_service_target').on('change', updateInstructions);

    // se le select venissero create dinamicamente in futuro, delega:
    $(document).on('change', '#pkinex_service_source, #pkinex_service_target, #pkinex_source_type', function () {
        updateInstructions();
    });

});

// ============================================================================
// PK InExPress — Async Import (Houzez) basic UI + loop
// ============================================================================
// EN: Requires pkinex_vars localized from PHP with:
//     - ajax_url
//     - ajax_nonce
//     - async_delay_ms
//
// IT: Richiede che pkinex_vars sia passato da PHP con:
//     - ajax_url
//     - ajax_nonce
//     - async_delay_ms
// ============================================================================

jQuery(function ($) {

    // EN: Current async job id (null = none)
    // IT: ID del job asincrono corrente (null = nessuno)
    var currentJobId = null;

    // EN: Flag indicating if the loop is currently running
    // IT: Flag che indica se il loop è in esecuzione
    var asyncRunning = false;

    // EN: Delay between steps (ms), comes from PHP but with fallback
    // IT: Pausa tra uno step e l'altro (ms), arriva dal PHP ma con fallback
    var asyncDelay = 1500;
    if (typeof pkinex_vars !== 'undefined' && pkinex_vars.async_delay_ms) {
        var parsed = parseInt(pkinex_vars.async_delay_ms, 10);
        if (!isNaN(parsed) && parsed > 100) {
            asyncDelay = parsed;
        }
    }

    // ------------------------------------------------------------------------
    // EN: Helper to update status text, progress and errors
    // IT: Helper per aggiornare testo di stato, progresso ed errori
    // ------------------------------------------------------------------------
    function pkinexAsyncUpdateUI(data) {
        if (!data) {
            return;
        }

        // Status text
        var statusText = data.status || 'running';
        jQuery('#pkinex-async-status-text').text(statusText);

        // Progress
        var total = 0;
        var processed = 0;

        if (typeof data.total !== 'undefined') {
            total = parseInt(data.total, 10);
            if (isNaN(total)) {
                total = 0;
            }
        }

        if (typeof data.processed !== 'undefined') {
            processed = parseInt(data.processed, 10);
            if (isNaN(processed)) {
                processed = 0;
            }
        }

        jQuery('#pkinex-async-progress').text(processed + ' / ' + total);

        // Errors
        var $errorsBox = jQuery('#pkinex-async-errors');
        $errorsBox.empty().hide();

        if (Array.isArray(data.errors) && data.errors.length > 0) {
            var list = jQuery('<ul></ul>');
            data.errors.forEach(function (msg) {
                list.append(jQuery('<li></li>').text(msg));
            });
            $errorsBox.append(list).show();
        }
    }

    // ------------------------------------------------------------------------
    // EN: Helper to set buttons state
    // IT: Helper per settare lo stato dei pulsanti
    // ------------------------------------------------------------------------
    function pkinexAsyncSetButtonsState(running) {
        asyncRunning = running;
        if (running) {
            jQuery('#pkinex-async-start-btn').prop('disabled', true);
            jQuery('#pkinex-async-cancel-btn').prop('disabled', false);
        } else {
            jQuery('#pkinex-async-start-btn').prop('disabled', false);
            jQuery('#pkinex-async-cancel-btn').prop('disabled', true);
        }
    }

    // ------------------------------------------------------------------------
    // EN: Step loop (calls the async_step endpoint until done or cancelled)
    // IT: Loop degli step (chiama l'endpoint async_step finché non finisce o viene annullato)
    // ------------------------------------------------------------------------
  function pkinexAsyncStepLoop() {
    if (!asyncRunning || !currentJobId) {
        return;
    }

    jQuery.post(pkinex_vars.ajax_url, {
        action: 'pkinex_async_import_step',
        nonce: pkinex_vars.ajax_nonce,
        job_id: currentJobId
    })
        .done(function (response) {
            console.log('PKINEX async step response:', response);

            if (!response || typeof response.success === 'undefined') {
                jQuery('#pkinex-async-status-text').text('Invalid server response');
                pkinexAsyncSetButtonsState(false);
                return;
            }

            if (!response.success) {
                // EN: Error from server — show message, stop loop
                // IT: Errore dal server — mostra messaggio e ferma il loop
                var msg = (response.data && response.data.message)
                    ? response.data.message
                    : 'Async import step failed.';
                jQuery('#pkinex-async-status-text').text(msg);

                var errors = [];
                if (response.data && Array.isArray(response.data.errors)) {
                    errors = response.data.errors;
                }
                pkinexAsyncUpdateUI({
                    total: 0,
                    processed: 0,
                    status: 'error',
                    errors: errors
                });

                pkinexAsyncSetButtonsState(false);
                return;
            }

            // EN: Successful step
            // IT: Step eseguito correttamente
            var data = response.data || {};
            pkinexAsyncUpdateUI(data);

            // 🛑 GUARDIA SPECIALE:
            // Se non c'è nulla da processare (total = 0, processed = 0)
            // e il batch risulta completato, fermiamo il loop.
            var total = 0;
            var processed = 0;

            if (typeof data.total !== 'undefined') {
                total = parseInt(data.total, 10);
                if (isNaN(total)) {
                    total = 0;
                }
            }

            if (typeof data.processed !== 'undefined') {
                processed = parseInt(data.processed, 10);
                if (isNaN(processed)) {
                    processed = 0;
                }
            }

            var batchDone = data.batch && data.batch.batch_done === true;
            var statusStr = (data.status || '').toString();

            if (
                total === 0 &&
                processed === 0 &&
                batchDone &&
                (
                    statusStr === 'import_done' ||
                    statusStr === 'update_done' ||
                    statusStr === 'delete_done'
                )
            ) {
                console.log('PKINEX: nessun elemento da importare/aggiornare/cancellare, stop async loop.');

                jQuery('#pkinex-async-status-text').text('Completato (0 elementi da elaborare).');
                jQuery('#pkinex-async-progress').text('0 / 0');
                pkinexAsyncSetButtonsState(false);
                return;
            }

            // Fine "normale": il backend ha impostato done = true
            if (data.done) {
                jQuery('#pkinex-async-status-text').text('done');
                pkinexAsyncSetButtonsState(false);
                return;
            }

            // Schedule next step with delay from PHP
            setTimeout(pkinexAsyncStepLoop, asyncDelay);
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            // EN: Network or generic failure
            // IT: Errore di rete o generico
            console.error('PKINEX async step AJAX FAIL:', textStatus, errorThrown, jqXHR);
            if (jqXHR && jqXHR.responseText) {
                console.error('PKINEX async step responseText:', jqXHR.responseText);
            }

            jQuery('#pkinex-async-status-text').text('AJAX error while running async step.');
            pkinexAsyncSetButtonsState(false);
        });

}


    // ------------------------------------------------------------------------
    // EN: Start button: call async_import_start
    // IT: Pulsante Start: chiama async_import_start
    // ------------------------------------------------------------------------
    jQuery('#pkinex-async-start-btn').on('click', function (e) {
        e.preventDefault();

        // Reset UI
        jQuery('#pkinex-async-status-text').text('starting…');
        jQuery('#pkinex-async-progress').text('0 / 0');
        jQuery('#pkinex-async-errors').empty().hide();

        jQuery.post(pkinex_vars.ajax_url, {
            action: 'pkinex_async_import_start',
            nonce: pkinex_vars.ajax_nonce
        })
            .done(function (response) {
                console.log('PKINEX async start response:', response);

                if (!response || typeof response.success === 'undefined') {
                    jQuery('#pkinex-async-status-text').text('Invalid server response on start.');
                    return;
                }

                if (!response.success) {
                    var msg = (response.data && response.data.message)
                        ? response.data.message
                        : 'Async import start failed.';
                    jQuery('#pkinex-async-status-text').text(msg);
                    return;
                }

                var data = response.data || {};
                currentJobId = data.job_id || null;

                if (!currentJobId) {
                    jQuery('#pkinex-async-status-text').text('Missing job_id in start response.');
                    return;
                }

                pkinexAsyncUpdateUI(data);
                pkinexAsyncSetButtonsState(true);
                pkinexAsyncStepLoop();
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                console.error('PKINEX async start AJAX FAIL:', textStatus, errorThrown, jqXHR);
                jQuery('#pkinex-async-status-text').text('AJAX error while starting async import.');
            });
    });

    // ------------------------------------------------------------------------
    // EN: Cancel button: stop local loop + ping cancel endpoint
    // IT: Pulsante Cancel: ferma il loop locale + chiama l’endpoint cancel
    // ------------------------------------------------------------------------
    jQuery('#pkinex-async-cancel-btn').on('click', function (e) {
        e.preventDefault();

        asyncRunning = false;

        if (!currentJobId) {
            jQuery('#pkinex-async-status-text').text('Cancelled (no job id).');
            pkinexAsyncSetButtonsState(false);
            return;
        }

        jQuery.post(pkinex_vars.ajax_url, {
            action: 'pkinex_async_import_cancel',
            nonce: pkinex_vars.ajax_nonce,
            job_id: currentJobId
        })
            .always(function () {
                console.log('PKINEX async cancel sent for job:', currentJobId);
                jQuery('#pkinex-async-status-text').text('Cancelled.');
                pkinexAsyncSetButtonsState(false);
            });
    });

});
