<?php

namespace PixelPulse\includes\pixelCodesFunctions;

class PixelCodes
{
  const VERSION = '1.0.0'; // Define a version for the plugin

  public function __construct()
  {
    add_action('wp_head', array($this, 'addGoogleAnalyticsCode'));
    add_action('wp_head', array($this, 'addMetaPixelCode'));
  }

  public function addGoogleAnalyticsCode()
  {
    $googleAnalyticsId = get_option('google_analytics_id');

    if ($googleAnalyticsId) {
      // Enqueue the Google Analytics script with version
      wp_enqueue_script('google-analytics', 'https://www.googletagmanager.com/gtag/js?id=' . esc_attr($googleAnalyticsId), array(), self::VERSION, true);

      // Add the inline script for initializing Google Analytics
      wp_add_inline_script('google-analytics', "
                window.dataLayer = window.dataLayer || [];
                function gtag() { dataLayer.push(arguments); }
                gtag('js', new Date());
                gtag('config', '" . esc_js($googleAnalyticsId) . "');
            ");
    }
  }

  public function addMetaPixelCode()
  {
    $metaPixelId = get_option('meta_pixel_id');

    if ($metaPixelId) {
      // Enqueue the Meta Pixel script with version
      wp_enqueue_script('meta-pixel', 'https://connect.facebook.net/en_US/fbevents.js', array(), self::VERSION, true);

      // Add the inline script for initializing Meta Pixel
      wp_add_inline_script('meta-pixel', "
                !function(f,b,e,v,n,t,s)
                {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
                n.queue=[];t=b.createElement(e);t.async=!0;
                t.src=v;s=b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t,s)}(window, document,'script',
                'https://connect.facebook.net/en_US/fbevents.js');
                fbq('init', '" . esc_js($metaPixelId) . "');
                fbq('track', 'PageView');
            ");

      // Add the noscript image fallback for Meta Pixel
      add_action('wp_footer', function () use ($metaPixelId) {
        echo '<noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=' . esc_attr($metaPixelId) . '&ev=PageView&noscript=1"/></noscript>';
      });
    }
  }

  // Placeholder functions for additional pixels
  public function addLinkedinPixelCode() {}
  public function addPinterestPixelCode() {}
  public function addMicrosoftPixelCode() {}
  public function addTiktokPixelCode() {}
  public function addXPixelCode() {}
  public function addClarityPixelCode() {}
}
