function setUTMCookies() {
  var params = ['utm_source', 'utm_medium', 'utm_campaign', 'utm_term', 'utm_content'];
  var foundUTM = false;

  params.forEach(function (param) {
    var value = new URLSearchParams(window.location.search).get(param);
    if (value) {
      document.cookie = param + '=' + encodeURIComponent(value) + '; path=/; max-age=' + (30 * 24 * 60 * 60); // Set cookie for 30 days
      foundUTM = true;
    }
  });

  if (!foundUTM) {
    params.forEach(function (param) {
      document.cookie = param + '=; path=/; max-age=0';
    });
  }
}

setUTMCookies();

function getAllUTMCookies() {
  var collectedUTMs = {};
  var cookies = document.cookie ? document.cookie.split(';') : [];


  cookies.forEach(function (cookie) {
    // Trim leading and trailing spaces
    var parts = cookie.trim().split('=');

    // Ensure both key and value exist
    if (parts.length === 2) {
      var key = parts[0].trim();
      var value = decodeURIComponent(parts[1].trim());

      // Check if it's a UTM or custom UTM-like parameter
      if (key.startsWith('utm_') || key.startsWith('utc_')) {
        collectedUTMs[key] = value;
      }
    }
  });

  return collectedUTMs;
}

