<?php

namespace PixelPulse\includes\consent;

class TrackingConsentModal
{
  public function registerHooks()
  {
    add_action('admin_enqueue_scripts', array($this, 'enqueueModalAssets'));
    add_action('admin_footer', array($this, 'renderModal'));
  }

  public function enqueueModalAssets()
  {
    wp_enqueue_style(
      'pixelpulse-consent-modal',
      plugin_dir_url(__FILE__) . '../../assets/css/consent-modal.css',
      array(),
      '1.0.0'
    );

    wp_enqueue_script(
      'pixelpulse-consent-modal',
      plugin_dir_url(__FILE__) . '../../assets/js/consent-modal.js',
      array('jquery'),
      '1.0.0',
      true
    );

    wp_localize_script('pixelpulse-consent-modal', 'pixelpulseConsentData', array(
      'ajaxurl' => admin_url('admin-ajax.php'),
      'nonce' => wp_create_nonce('pixelpulse_tracking_consent_nonce'),
    ));
  }

  public function renderModal()
  {
    // Only show if consent hasn't been decided
    if (get_option('pixelpulse_tracking_consent_shown') !== 'pending') {
      return;
    }
?>
    <div id="pixelpulse-consent-modal" class="pixelpulse-modal">
      <div class="pixelpulse-modal-content">
        <div class="pixelpulse-modal-header">
          <div class="logo-title-wrapper">
            <svg class="pixelpulse-logo" width="32" height="32" viewBox="0 0 32 32" fill="none">
              <path d="M16 2L2 9V23L16 30L30 23V9L16 2Z" fill="#2271b1" />
              <path d="M16 8L8 12V20L16 24L24 20V12L16 8Z" fill="white" />
            </svg>
            <h2><?php _e('Help Us Improve PixelPulse', 'pixel-pulse-for-woocommerce'); ?></h2>
          </div>
        </div>
        <div class="pixelpulse-modal-body">
          <div class="consent-benefits">
            <ul>
              <li>
                <span class="benefit-icon">📈</span>
                <span class="benefit-text"><?php _e('Get a better plugin tailored to YOUR needs', 'pixel-pulse-for-woocommerce'); ?></span>
              </li>
              <li>
                <span class="benefit-icon">🛡️</span>
                <span class="benefit-text"><?php _e('Only anonymous data - your privacy is protected', 'pixel-pulse-for-woocommerce'); ?></span>
              </li>
            </ul>
          </div>
        </div>
        <div class="pixelpulse-modal-footer">
          <button id="pixelpulse-allow-tracking" class="button button-primary">
            <?php _e('Yes, count me in!', 'pixel-pulse-for-woocommerce'); ?>
          </button>
          <button id="pixelpulse-deny-tracking" class="button button-secondary">
            <?php _e('Skip', 'pixel-pulse-for-woocommerce'); ?>
          </button>
        </div>
      </div>
    </div>
<?php
  }
}
