<?php

namespace PixelPulse\includes;

class WooCommerceModifications
{
  public function __construct()
  {
    add_filter('woocommerce_loop_add_to_cart_args', array($this, 'modifyAddToCartButton'), 10, 2);
  }
  public function modifyAddToCartButton($args, $product)
  {
    // Add custom data attributes to the add-to-cart button
    $args['attributes']['data-product_name']    = $product->get_name();
    $args['attributes']['data-product_sku']     = $product->get_sku();
    $args['attributes']['data-price']           = $product->get_price();

    $categories = $product->get_category_ids();
    if (!empty($categories)) {
      $category = get_term($categories[0], 'product_cat');
      $args['attributes']['data-category'] = $category ? $category->name : '';
    } else {
      $args['attributes']['data-category'] = '';
    }

    return $args;
  }
}
