<?php

namespace PixelPulse\includes\GAevents\handlers;

use PixelPulse\common\interfaces\TrackerInterface;

class UpsellOrderHandler implements TrackerInterface
{
  public function registerHooks(): void
  {
    add_action('wp_ajax_addUpsellToOrder', array($this, 'addUpsellToOrder'));

    add_action('wp_ajax_nopriv_addUpsellToOrder', array($this, 'addUpsellToOrder'));

    add_action('wp_ajax_removeUpsellFromOrder', array($this, 'removeUpsellFromOrder'));

    add_action('wp_ajax_nopriv_removeUpsellFromOrder', array($this, 'removeUpsellFromOrder'));
  }

  public function addUpsellToOrder()
  {

    if (!isset($_POST['orderId']) || !isset($_POST['productId']) || !isset($_POST['nonce'])) {
      wp_send_json_error('Missing parameters');
    }

    $orderId = intval($_POST['orderId']);
    $productId = intval($_POST['productId']);
    $nonce = sanitize_text_field(wp_unslash($_POST['nonce']));

    if (!wp_verify_nonce($nonce, 'upsell_action')) {
      wp_send_json_error('Invalid nonce');
    }

    $order = wc_get_order($orderId);
    if (!$order) {
      wp_send_json_error('Invalid order');
    }

    $product = wc_get_product($productId);
    if (!$product) {
      wp_send_json_error('Invalid product');
    }

    // Add the upsell product to the order
    $order->add_product($product, 1); // Add one quantity of the upsell product
    $order->calculate_totals();
    $order->save();

    wp_send_json_success('Upsell added');
  }
  public function removeUpsellFromOrder()
  {
    if (!isset($_POST['orderId']) || !isset($_POST['productId']) || !isset($_POST['nonce'])) {
      wp_send_json_error('Missing parameters');
    }

    $orderId    = intval($_POST['orderId']);
    $productId  = intval($_POST['productId']);
    $nonce      = sanitize_text_field(wp_unslash($_POST['nonce']));

    if (!wp_verify_nonce($nonce, 'upsell_action')) {
      wp_send_json_error('Invalid nonce');
    }

    $order = wc_get_order($orderId);

    if (!$order) {
      wp_send_json_error('Invalid order');
    }

    $items = $order->get_items();

    $foundProduct = false;

    foreach ($items as $itemId => $item) {
      $orderProductsId = $item->get_product_id();
      if ($productId === $orderProductsId) {

        $order->remove_item($itemId);
        $foundProduct = true;

        break;
      }
    }

    if ($foundProduct) {
      $order->calculate_totals();
      $order->save();

      wp_send_json_success('Product removed successfully');
    } else {
      wp_send_json_error('Product not found in order');
    }
  }
}
