<?php

namespace PixelPulse\includes\GAevents\GAtrackers\product\viewSingleProduct;

class TrackViewItemEvent
{
  public function registerHooks(): void
  {
    add_action('woocommerce_after_single_product', array($this, 'trackViewItemEvent'));
  }

  public function trackViewItemEvent()
  {
    if (is_cart()) {
      return;
    }

    global $product;

    if ($product) {
      // Ensure jQuery is enqueued
      wp_enqueue_script('jquery');
      wp_register_script('track-view-item', '');
      wp_enqueue_script('track-view-item');

      $inline_script = "
        jQuery(document).ready(function($) {
          var utmParams = getAllUTMCookies();

          gtag('event', 'view_item', {
            'items': [{
              'id': '" . esc_js($product->get_id()) . "',
              'name': '" . esc_js($product->get_name()) . "',
              'stock_quantity': '" . esc_js($product->get_stock_quantity()) . "',
              'sku': '" . esc_js($product->get_sku()) . "',
              'price': '" . esc_js($product->get_price()) . "'
            }],
            ...utmParams
          });
          fbq('track', 'view_item', {
            'items': [{
              'id': '" . esc_js($product->get_id()) . "',
              'name': '" . esc_js($product->get_name()) . "',
              'stock_quantity': '" . esc_js($product->get_stock_quantity()) . "',
              'sku': '" . esc_js($product->get_sku()) . "',
              'price': '" . esc_js($product->get_price()) . "'
            }],
            ...utmParams
          });
        });
      ";

      wp_add_inline_script('track-view-item', $inline_script);
    }
  }
}
