<?php

namespace PixelPulse\includes\GAevents\GAtrackers\product\viewListProducts;

class TrackViewItemListEvent
{
  public function registerHooks(): void
  {
    add_action('woocommerce_after_shop_loop', array($this, 'trackViewItemListEvent'));
  }
  public function trackViewItemListEvent()
  {
    global $woocommerce_loop;

    $products = array();
    $loop_products = wc_get_products(array('limit' => -1));

    foreach ($loop_products as $product) {
      $products[] = array(
        'id' => $product->get_id(),
        'name' => $product->get_name(),
        'sku' => $product->get_sku(),
        'price' => $product->get_price(),
        'stock_quantity' => $product->get_stock_quantity(),
        'category' => $product->get_category_ids() ? wp_get_post_terms($product->get_id(), 'product_cat')[0]->name : '',
      );
    }

    // Register and enqueue jQuery
    wp_enqueue_script('jquery');

    // Register our tracking script
    wp_register_script(
      'view-item-list-tracker',
      '',
      ['jquery'],
      '1.0.0',
      true
    );

    // Enqueue our script
    wp_enqueue_script('view-item-list-tracker');

    // Add inline script with data
    wp_add_inline_script(
      'view-item-list-tracker',
      sprintf(
        'jQuery(document).ready(function($) {
          var utmParams = getAllUTMCookies();
          gtag("event", "view_item_list", {
            "items": %s,
            ...utmParams
          });
          fbq("track", "view_item_list", {
            "items": %s,
            ...utmParams
          });
        });',
        wp_json_encode($products),
        wp_json_encode($products)
      )
    );
  }
}
