<?php

namespace PixelPulse\includes\GAevents\GAtrackers\coupon;

use PixelPulse\common\interfaces\TrackerInterface;

class CouponTracking implements TrackerInterface
{
  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueueCouponTracking'));
  }

  public function enqueueCouponTracking(): void
  {
    if (!is_checkout() && !is_cart()) {
      return;
    }

    wp_enqueue_script('jquery');

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript(),
      'after'
    );
    error_log('Coupon tracking inline script added');
  }

  private function getInlineScript(): string
  {
    return "
      document.addEventListener('DOMContentLoaded', function() {
        console.log('Coupon tracking initialized');

        function sendCouponEventToGA(eventType, couponCode, items) {
          var utmParams = getAllUTMCookies();

          gtag('event', eventType, {
            'event_category': 'Ecommerce',
            'event_label': 'Coupon',
            'coupon_code': couponCode,
            'items': items,
            ...utmParams
          });

          fbq('track', eventType, {
            'coupon_code': couponCode,
            'items': items,
            ...utmParams
          });
        }

        // Listen for successful coupon applications using WooCommerce's events
        jQuery(document.body).on('applied_coupon removed_coupon', function(event, couponCode) {
          console.log('Coupon event detected:', event.type, couponCode);

          // Get current cart data
          fetch('/wp-json/wc/store/cart')
            .then(response => response.json())
            .then(cartData => {
              console.log('Cart data:', cartData);

              // Format items data
              let items = cartData.items.map(item => ({
                id: item.id,
                name: item.name.replace(/&#215;/g, 'x'), // Fix HTML entities
                price: item.prices.price / 100, // Convert cents to dollars
                quantity: item.quantity,
                sku: item.sku ? item.sku.replace(/&#215;/g, 'x') : ''
              }));

              // Determine event type
              const eventType = event.type === 'applied_coupon' ? 'apply_coupon' : 'remove_coupon';

              // Clean up coupon code
              const cleanCouponCode = couponCode.trim();

              console.log('Sending tracking event:', {
                eventType: eventType,
                couponCode: cleanCouponCode,
                items: items
              });

              sendCouponEventToGA(eventType, cleanCouponCode, items);
            })
            .catch(error => console.error('Error fetching cart data:', error));
        });

        console.log('Coupon tracking initialized - using WooCommerce events');
      });";
  }
}
