<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout\events;

class TrackShippingInfoEvent
{
  public function registerHooks()
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueueShippingInfoTracking'));
  }

  public function enqueueShippingInfoTracking()
  {
    if (!is_checkout()) {
      return;
    }

    // Get cart items
    $products = [];
    if (WC()->cart && !WC()->cart->is_empty()) {
      foreach (WC()->cart->get_cart() as $cartItemKey => $cartItem) {
        $product = $cartItem['data'];
        $products[] = [
          'item_name' => $product->get_name(),
          'item_id' => $product->get_id(),
          'sku' => $product->get_sku(),
          'price' => $product->get_price(),
          'quantity' => $cartItem['quantity']
        ];
      }
    }

    $data = [
      'currency' => get_woocommerce_currency(),
      'products' => $products
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getInlineScript(array $data): string
  {
    return "
      document.addEventListener('DOMContentLoaded', function() {
        var utmParams = getAllUTMCookies();

        function debounce(func, delay) {
          let timeout;
          return function(...args) {
            clearTimeout(timeout);
            timeout = setTimeout(() => func.apply(this, args), delay);
          };
        }

        function trackShippingInfoEvent() {
          let shippingCountry = document.getElementById('shipping-country');
          let shippingCity = document.getElementById('shipping-city');
          let shippingPostcode = document.getElementById('shipping-postcode');
          let shippingFirstName = document.getElementById('shipping-first_name');
          let shippingLastName = document.getElementById('shipping-last_name');
          let shippingPhone = document.getElementById('shipping-phone');
          let shippingEmail = document.getElementById('email');

          if (shippingPhone && shippingEmail) {
            let country = shippingCountry.value;
            let city = shippingCity.value;
            let postalCode = shippingPostcode.value;
            let firstName = shippingFirstName.value;
            let lastName = shippingLastName.value;
            let email = shippingEmail.value.trim();
            let phone = shippingPhone.value.trim();

            if (email === '' && phone === '') {
              return;
            }

            gtag('event', 'add_shipping_info', {
              'currency': '" . esc_js($data['currency']) . "',
              'shipping_tier': 'Standard',
              'email': email,
              'first_name': firstName,
              'last_name': lastName,
              'phone': phone,
              'country': country,
              'city': city,
              'postal_code': postalCode,
              'items': " . wp_json_encode($data['products']) . ",
              ...utmParams
            });

            fbq('track', 'add_shipping_info', {
              'currency': '" . esc_js($data['currency']) . "',
              'shipping_tier': 'Standard',
              'email': email,
              'first_name': firstName,
              'last_name': lastName,
              'phone': phone,
              'country': country,
              'city': city,
              'postal_code': postalCode,
              'items': " . wp_json_encode($data['products']) . ",
              ...utmParams
            });
          }
        }

        const debouncedTrackShippingInfoEvent = debounce(trackShippingInfoEvent, 3000);

        const shippingFields = [
          'shipping-country',
          'shipping-city',
          'shipping-postcode',
          'shipping-first_name',
          'shipping-last_name',
          'shipping-phone',
          'email'
        ];

        shippingFields.forEach(fieldId => {
          const element = document.getElementById(fieldId);
          if (element) {
            element.addEventListener('input', debouncedTrackShippingInfoEvent);
          }
        });

        if (!document.getElementById('shipping-country') || !document.getElementById('shipping-phone')) {
          const observer = new MutationObserver(function(mutations) {
            if (document.getElementById('shipping-country') && document.getElementById('shipping-phone')) {
              debouncedTrackShippingInfoEvent();
              shippingFields.forEach(fieldId => {
                const element = document.getElementById(fieldId);
                if (element && !element.hasListener) {
                  element.addEventListener('input', debouncedTrackShippingInfoEvent);
                  element.hasListener = true;
                }
              });
              observer.disconnect();
            }
          });

          observer.observe(document.body, {
            childList: true,
            subtree: true
          });
        }
      });";
  }
}
