<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout\events;

class TrackPurchaseEvent
{
  public function registerHooks()
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueueOrderButtonTracking'));
    add_action('woocommerce_thankyou', array($this, 'enqueuePurchaseTracking'));
  }

  public function enqueueOrderButtonTracking()
  {
    if (!is_checkout() || is_order_received_page()) {
      return;
    }

    $data = [
      'currency' => get_woocommerce_currency(),
      'products' => $this->getCartItems()
    ];

    wp_add_inline_script(
      'jquery',
      $this->getOrderButtonScript($data),
      'after'
    );
  }

  private function getCartItems(): array
  {
    $items = [];
    if (WC()->cart && !WC()->cart->is_empty()) {
      foreach (WC()->cart->get_cart() as $cartItem) {
        $product = $cartItem['data'];
        $items[] = [
          'id' => $product->get_id(),
          'name' => $product->get_name(),
          'price' => $product->get_price(),
          'quantity' => $cartItem['quantity'],
        ];
      }
    }
    return $items;
  }

  private function getOrderButtonScript(array $data): string
  {
    return "
      jQuery(document).ready(function($) {
        var utmParams = getAllUTMCookies();

        $(document.body).on('click', '#place_order', function() {
          gtag('event', 'purchase_initiated', {
            'currency': '" . esc_js($data['currency']) . "',
            'items': " . wp_json_encode($data['products']) . ",
            ...utmParams
          });

          fbq('track', 'purchase_initiated', {
            'currency': '" . esc_js($data['currency']) . "',
            'items': " . wp_json_encode($data['products']) . ",
            ...utmParams
          });
        });
      });";
  }

  public function enqueuePurchaseTracking($orderId)
  {
    if (!is_checkout() || !is_order_received_page()) {
      return;
    }

    $order = wc_get_order($orderId);
    if (!$order) {
      return;
    }

    $data = [
      'transactionId' => $order->get_order_number(),
      'email' => $order->get_billing_email(),
      'phone' => $order->get_billing_phone(),
      'total' => $order->get_total(),
      'currency' => $order->get_currency(),
      'items' => $this->getOrderItems($order)
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getOrderItems($order): array
  {
    $items = [];
    foreach ($order->get_items() as $itemId => $item) {
      $product = $item->get_product();
      $items[] = [
        'id' => $product->get_id(),
        'name' => $product->get_name(),
        'price' => $product->get_price(),
        'quantity' => $item->get_quantity(),
      ];
    }
    return $items;
  }

  private function getInlineScript(array $data): string
  {
    return "
      document.addEventListener('DOMContentLoaded', function() {
        var transactionId = '" . esc_js($data['transactionId']) . "';

        if (!localStorage.getItem('purchase_sent_' + transactionId)) {
          gtag('event', 'purchase', {
            'transaction_id': transactionId,
            'email': '" . esc_js($data['email']) . "',
            'phone': '" . esc_js($data['phone']) . "',
            'value': '" . esc_js($data['total']) . "',
            'currency': '" . esc_js($data['currency']) . "',
            'items': " . wp_json_encode($data['items']) . "
          });

          fbq('track', 'purchase', {
            'transaction_id': transactionId,
            'email': '" . esc_js($data['email']) . "',
            'phone': '" . esc_js($data['phone']) . "',
            'value': '" . esc_js($data['total']) . "',
            'currency': '" . esc_js($data['currency']) . "',
            'items': " . wp_json_encode($data['items']) . "
          });

          localStorage.setItem('purchase_sent_' + transactionId, true);
        }
      });";
  }
}
