<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout\events;

class TrackPaymentInfoEvent
{
  public function registerHooks()
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueuePaymentInfoTracking'));
  }

  public function enqueuePaymentInfoTracking()
  {
    if (!is_checkout()) {
      return;
    }

    $data = [
      'currency' => get_woocommerce_currency(),
      'cartTotal' => WC()->cart->get_total(''),
      'products' => $this->getCartItems()
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getCartItems(): array
  {
    $cartItems = [];
    if (WC()->cart && !WC()->cart->is_empty()) {
      foreach (WC()->cart->get_cart() as $cartItem) {
        $product = $cartItem['data'];
        $cartItems[] = [
          'item_id' => $product->get_id(),
          'item_name' => $product->get_name(),
          'sku' => $product->get_sku(),
          'price' => $product->get_price(),
          'quantity' => $cartItem['quantity']
        ];
      }
    }
    return $cartItems;
  }

  private function getInlineScript(array $data): string
  {
    return "
      jQuery(document).ready(function($) {
        var utmParams = getAllUTMCookies();

        $(document.body).on('change', 'input[name=\"radio-control-wc-payment-method-options\"], input[name=\"payment_method\"]', function() {
          var paymentMethod = $(this).val();

          var paymentMethodNames = {
            'cheque': 'Check',
            'bacs': 'Bank Transfer',
            'cod': 'Cash on Delivery',
            'paypal': 'PayPal',
            'stripe': 'Credit Card'
          };

          var friendlyPaymentMethod = paymentMethodNames[paymentMethod] || 'Other';

          gtag('event', 'add_payment_info', {
            'payment_type': friendlyPaymentMethod,
            'currency': '" . esc_js($data['currency']) . "',
            'value': " . esc_js($data['cartTotal']) . ",
            'items': " . wp_json_encode($data['products']) . ",
            ...utmParams
          });

          fbq('track', 'add_payment_info', {
            'payment_type': friendlyPaymentMethod,
            'currency': '" . esc_js($data['currency']) . "',
            'value': " . esc_js($data['cartTotal']) . ",
            'items': " . wp_json_encode($data['products']) . ",
            ...utmParams
          });
        });
      });";
  }
}
