<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout\events;

class TrackCheckoutInactivityTimeout
{
  public function registerHooks()
  {
    add_action('wp_enqueue_scripts', array($this, 'enqueueInactivityScript'));
  }

  public function enqueueInactivityScript()
  {
    if (!is_checkout()) {
      return;
    }

    // Register and enqueue the script
    wp_register_script(
      'checkout-inactivity-tracker',
      '',  // Empty string since we're using inline script
      array('jquery'),  // Add jQuery as a dependency
      '1.0.0',
      true
    );

    wp_enqueue_script('checkout-inactivity-tracker');

    // Add the inline script
    wp_add_inline_script(
      'checkout-inactivity-tracker',
      $this->getInactivityScript()
    );
  }

  private function getInactivityScript(): string
  {
    return "
      document.addEventListener('DOMContentLoaded', function() {
        let inactivityTimer;

        function startInactivityTimer() {
          clearTimeout(inactivityTimer);

          let email = document.getElementById('email') ? document.getElementById('email').value.trim() : '';
          let phone = document.getElementById('shipping-phone') ? document.getElementById('shipping-phone').value.trim() : '';

          if (email !== '' || phone !== '') {
            inactivityTimer = setTimeout(() => {
              gtag('event', 'inactivity_shipping_info', {
                'event_category': 'Checkout',
                'event_label': 'User inactive on checkout',
                'email': email,
                'phone': phone,
              });
              fbq('track', 'inactivity_shipping_info', {
                'email': email,
                'phone': phone,
              });
            }, 60000); // 60 seconds of inactivity
          }
        }

        function resetInactivityTimer() {
          clearTimeout(inactivityTimer);
          startInactivityTimer();
        }

        window.addEventListener('mousemove', resetInactivityTimer);
        window.addEventListener('keydown', resetInactivityTimer);
        window.addEventListener('scroll', resetInactivityTimer);

        startInactivityTimer();

        const emailField = document.getElementById('email');
        const phoneField = document.getElementById('shipping-phone');

        if (emailField) emailField.addEventListener('input', resetInactivityTimer);
        if (phoneField) phoneField.addEventListener('input', resetInactivityTimer);
      });
    ";
  }
}
