<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout\events;

class TrackBeginCheckoutEvent
{
  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', [$this, 'enqueueBeginCheckoutTracking']);
  }

  public function enqueueBeginCheckoutTracking(): void
  {
    if (!is_checkout() || is_order_received_page()) {
      return;
    }

    $cartItems = [];
    foreach (WC()->cart->get_cart() as $cartItemKey => $cartItem) {
      $product = $cartItem['data'];
      $cartItems[] = [
        'id' => $product->get_id(),
        'name' => $product->get_name(),
        'sku' => $product->get_sku(),
        'price' => $product->get_price(),
        'quantity' => $cartItem['quantity']
      ];
    }

    $data = [
      'cartItems' => $cartItems
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getInlineScript(array $data): string
  {
    return "
            jQuery(document).ready(function($) {
                var utmParams = getAllUTMCookies();

                gtag('event', 'begin_checkout', {
                    'items': " . wp_json_encode($data['cartItems']) . ",
                    ...utmParams
                });

                fbq('track', 'begin_checkout', {
                    'items': " . wp_json_encode($data['cartItems']) . ",
                    ...utmParams
                });
            });
        ";
  }
}
