<?php

namespace PixelPulse\includes\GAevents\GAtrackers\checkout;

use PixelPulse\includes\GAevents\GAtrackers\checkout\events\TrackBeginCheckoutEvent;
use PixelPulse\includes\GAevents\GAtrackers\checkout\events\TrackCheckoutInactivityTimeout;
use PixelPulse\includes\GAevents\GAtrackers\checkout\events\TrackPaymentInfoEvent;
use PixelPulse\includes\GAevents\GAtrackers\checkout\events\TrackPurchaseEvent;
use PixelPulse\includes\GAevents\GAtrackers\checkout\events\TrackShippingInfoEvent;
use PixelPulse\includes\GAevents\GAtrackers\checkout\events\CartAbandonmentTracker;
use PixelPulse\common\interfaces\TrackerInterface;

class CheckoutTracking implements TrackerInterface
{
  private array $trackers = [];
  public function __construct()
  {
    $this->trackers = [
      new TrackBeginCheckoutEvent(),
      new TrackCheckoutInactivityTimeout(),
      new TrackPaymentInfoEvent(),
      new TrackPurchaseEvent(),
      new TrackShippingInfoEvent(),
      new CartAbandonmentTracker(),
    ];
  }

  public function registerHooks(): void
  {
    foreach ($this->trackers as $tracker) {
      $tracker->registerHooks();
    }
  }
}
