<?php

namespace PixelPulse\includes\GAevents\GAtrackers\cart\viewCart;

class ViewCartTracker
{
  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', [$this, 'enqueueViewCartTracking']);
  }

  public function enqueueViewCartTracking(): void
  {
    if (!is_cart() || WC()->cart->get_cart_contents_count() == 0) {
      return;
    }

    // Ensure jQuery is loaded
    wp_enqueue_script('jquery');

    // Register our tracking script
    wp_register_script(
      'view-cart-tracker',
      '',  // Empty string since we're using inline script
      ['jquery'],
      '1.0.0',
      true
    );

    // Enqueue our script
    wp_enqueue_script('view-cart-tracker');

    // Prepare cart data
    $cart_data = $this->prepareCartData();

    // Add inline script
    wp_add_inline_script(
      'view-cart-tracker',
      $this->getInlineScript($cart_data)
    );
  }

  private function prepareCartData(): array
  {
    $cartItems = [];
    foreach (WC()->cart->get_cart() as $cartItemKey => $cartItem) {
      $product = $cartItem['data'];
      $cartItems[] = [
        'id' => $product->get_id(),
        'sku' => $product->get_sku(),
        'name' => $product->get_name(),
        'price' => $product->get_price(),
        'quantity' => $cartItem['quantity']
      ];
    }
    return $cartItems;
  }

  private function getInlineScript(array $cart_data): string
  {
    $data = [
      'currency' => get_woocommerce_currency(),
      'cartTotal' => WC()->cart->get_cart_contents_total(),
      'cartItems' => $cart_data
    ];

    return "
            jQuery(document).ready(function($) {
                var utmParams = getAllUTMCookies();
                var cartData = " . wp_json_encode($data) . ";

                gtag('event', 'view_cart', {
                    currency: cartData.currency,
                    value: cartData.cartTotal,
                    items: cartData.cartItems,
                    ...utmParams
                });

                fbq('track', 'view_cart', {
                    currency: cartData.currency,
                    value: cartData.cartTotal,
                    items: cartData.cartItems,
                    ...utmParams
                });
            });
        ";
  }
}
