<?php

namespace PixelPulse\includes\GAevents\GAtrackers\cart\removeFromCart;

class RemoveFromCartTracker
{
  private $userId;

  public function __construct()
  {
    $this->userId = get_current_user_id();
  }

  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', [$this, 'enqueueRemoveFromCartTracking']);
  }

  public function enqueueRemoveFromCartTracking(): void
  {
    if (!is_cart()) {
      return;
    }

    $products = [];
    foreach (WC()->cart->get_cart() as $cartItemKey => $cartItem) {
      $product = $cartItem['data'];
      $products[$cartItemKey] = [
        'id' => $product->get_id(),
        'name' => $product->get_name(),
        'sku' => $product->get_sku(),
        'price' => $product->get_price(),
        'category' => $product->get_category_ids() ? wp_get_post_terms($product->get_id(), 'product_cat')[0]->name : '',
        'quantity' => $cartItem['quantity'],
      ];
    }

    $data = [
      'userId' => $this->userId,
      'currency' => get_woocommerce_currency(),
      'products' => $products
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getInlineScript(array $data): string
  {
    return "
            var cachedCartItems = " . wp_json_encode($data['products']) . ";
            jQuery(document).ready(function($) {
                var utmParams = getAllUTMCookies();
                var sentEvents = new Set();

                $(document).on('click', '.product-remove a', function(e) {
                    let href = $(this).attr('href');
                    if (!href) return;

                    let urlParams = new URLSearchParams(href.split('?')[1]);
                    let cartItemKey = urlParams.get('remove_item');

                    let productDetails = cachedCartItems[cartItemKey];
                    if (productDetails && !sentEvents.has(cartItemKey)) {
                        sentEvents.add(cartItemKey);

                        gtag('event', 'remove_from_cart', {
                            'user_id': '" . esc_js($data['userId']) . "',
                            'currency': '" . esc_js($data['currency']) . "',
                            'items': [{
                                'id': productDetails.id,
                                'name': productDetails.name,
                                'sku': productDetails.sku,
                                'price': productDetails.price,
                                'category': productDetails.category,
                                'quantity': productDetails.quantity,
                                'cart_item_key': cartItemKey
                            }],
                            ...utmParams
                        });

                        fbq('track', 'remove_from_cart', {
                            product_id: productDetails.id,
                            quantity: productDetails.quantity,
                            product_sku: productDetails.sku,
                            product_name: productDetails.name,
                            ...utmParams
                        });
                    }
                });
            });
        ";
  }
}
