<?php

namespace PixelPulse\includes\GAevents\GAtrackers\cart\addToCart;

use PixelPulse\common\interfaces\TrackerInterface;

class UpsellTracker implements TrackerInterface
{
  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', [$this, 'enqueueUpsellAddToCartTracking']);
  }

  public function enqueueUpsellAddToCartTracking(): void
  {
    if (!is_product()) {
      return;
    }

    // Ensure jQuery is loaded
    wp_enqueue_script('jquery');

    // Register our tracking script
    wp_register_script(
      'upsell-add-to-cart-tracker',
      '',  // Empty string since we're using inline script
      ['jquery'],
      '1.0.0',
      true
    );

    // Enqueue our script
    wp_enqueue_script('upsell-add-to-cart-tracker');

    $data = [
      'userId' => get_current_user_id(),
      'currency' => get_woocommerce_currency()
    ];

    // Add inline script
    wp_add_inline_script(
      'upsell-add-to-cart-tracker',
      $this->getInlineScript($data)
    );
  }

  private function getInlineScript(array $data): string
  {
    return "
            jQuery(document).ready(function($) {
                var utmParams = getAllUTMCookies();

                function trackAddToCart(productId, productQty, productSku, productName, productPrice, productCategory) {
                    gtag('event', 'add_to_cartee', {
                        'user_id': '" . esc_js($data['userId']) . "',
                        'currency': '" . esc_js($data['currency']) . "',
                        'items': [{
                            'id': productId,
                            'sku': productSku,
                            'name': productName,
                            'price': productPrice,
                            'category': productCategory,
                            'quantity': productQty
                        }],
                        ...utmParams
                    });

                    fbq('track', 'add_to_cart', {
                        product_id: productId,
                        quantity: productQty,
                        product_sku: productSku,
                        product_name: productName,
                        product_price: productPrice,
                        ...utmParams
                    });
                }

                $(document).on('added_to_cart', function(event, fragments, cartHash, \$button) {
                    var productId = \$button.data('product_id');
                    var productQty = \$button.data('quantity') || 1;
                    var productSku = \$button.data('product_sku') || '';
                    var productName = \$button.data('product_name') || '';
                    var productPrice = \$button.data('price') || '';
                    var productCategory = \$button.data('category') || '';

                    trackAddToCart(productId, productQty, productSku, productName, productPrice, productCategory);
                });
            });
        ";
  }
}
