<?php

namespace PixelPulse\includes\GAevents\GAtrackers\cart\addToCart;

use PixelPulse\common\interfaces\TrackerInterface;

class DynamicPricingTracker implements TrackerInterface
{
  public function registerHooks(): void
  {
    add_action('wp_enqueue_scripts', [$this, 'trackAddToCartDynamicPricing']);
  }

  public function trackAddToCartDynamicPricing(): void
  {
    if (!is_product()) {
      return;
    }

    $data = [
      'currency' => get_woocommerce_currency()
    ];

    wp_add_inline_script(
      'jquery',
      $this->getInlineScript($data),
      'after'
    );
  }

  private function getInlineScript(array $data): string
  {
    return "
            jQuery(document).ready(function($) {
                var utmParams = getAllUTMCookies();

                function sendDynamicEvent(productId, productQty, productPrice, productName) {
                    gtag('event', 'add_to_cart', {
                        'event_category': 'Ecommerce',
                        'event_label': productName,
                        'Total value': parseFloat(productPrice) * productQty / 100 + ' ' + '" . esc_js($data['currency']) . "',
                        'items': [{
                            'id': productId,
                            'name': productName,
                            'quantity': productQty,
                            'price': productPrice / 100 + ' ' + '" . esc_js($data['currency']) . "'
                        }],
                        ...utmParams
                    });

                    fbq('track', 'add_to_cart', {
                        product_id: productId,
                        quantity: productQty,
                        product_price: productPrice,
                        product_name: productName,
                        ...utmParams
                    });
                }

                $('form.cart').on('submit', function(e) {
                    var \$form = $(this);
                    var productId = \$form.find('button[name=\"add-to-cart\"]').val();
                    var productQty = \$form.find('input.qty').val() || 1;
                    var productName = \$form.closest('.product').find('.product_title').text();
                    var productPrice = \$form.closest('.product').find('.price .amount').first().text().replace(/[^0-9\.]/g, '');

                    sendDynamicEvent(productId, productQty, productPrice, productName);
                });
            });
        ";
  }
}
