<?php

namespace PixelPulse\includes\GAevents\GAtrackers\cart;

use PixelPulse\common\interfaces\TrackerInterface;
use PixelPulse\includes\GAevents\GAtrackers\cart\addToCart\AjaxAddToCart;
use PixelPulse\includes\GAevents\GAtrackers\cart\addToCart\DynamicPricingTracker;
use PixelPulse\includes\GAevents\GAtrackers\cart\addToCart\UpsellTracker;
use PixelPulse\includes\GAevents\GAtrackers\cart\removeFromCart\RemoveFromCartTracker;
use PixelPulse\includes\GAevents\GAtrackers\cart\viewCart\ViewCartTracker;
use PixelPulse\includes\WooCommerceModifications;


class AddToCartTracker implements TrackerInterface
{
  private array $trackers = [];
  public function __construct()
  {
    new WooCommerceModifications();
    $this->trackers = [
      new AjaxAddToCart(),
      new DynamicPricingTracker(),
      new UpsellTracker(),
      new RemoveFromCartTracker(),
      new ViewCartTracker(),
    ];
  }

  public function registerHooks(): void
  {
    foreach ($this->trackers as $tracker) {
      $tracker->registerHooks();
    }
  }
}
