<?php

namespace PixelPulse\includes\GAevents;

use PixelPulse\includes\GAevents\GAtrackers\cart\AddToCartTracker;
use PixelPulse\includes\GAevents\GAtrackers\checkout\CheckoutTracking;
use PixelPulse\includes\GAevents\handlers\UpsellOrderHandler;
use PixelPulse\includes\GAevents\GAtrackers\coupon\CouponTracking; //ok
use PixelPulse\includes\GAevents\GAtrackers\product\ProductTracking; //ok
use PixelPulse\includes\GAevents\GAtrackers\meta\MetaEventTracker;

class CartTrack
{
  private $userId;
  private $trackers = [];
  public function __construct()
  {
    $this->userId = get_current_user_id();
    $this->initializeTrackers();
    $this->registerHooks();
  }
  private function initializeTrackers(): void
  {
    $this->trackers = [
      new AddToCartTracker(), //ok
      new UpsellOrderHandler(),
      new CheckoutTracking(),
      new CouponTracking(),
      new ProductTracking(),
    ];
  }
  private function registerHooks(): void
  {
    foreach ($this->trackers as $tracker) {
      $tracker->registerHooks();
    }
  }
}
