jQuery(document).ready(function ($) {
  // Show modal with animation
  function showModal() {
    const modal = $('#pixelpulse-consent-modal');
    modal.addClass('show');
  }

  // Hide modal with animation
  function hideModal() {
    const modal = $('#pixelpulse-consent-modal');
    modal.removeClass('show');
    setTimeout(() => {
      modal.hide();
    }, 300);
  }

  // Handle consent response
  function handleConsent(allow) {
    $.ajax({
      url: pixelpulseConsentData.ajaxurl,
      type: 'POST',
      data: {
        action: 'pixelpulse_handle_tracking_consent',
        consent: allow ? 'allow' : 'deny',
        nonce: pixelpulseConsentData.nonce
      },
      success: function (response) {
        if (response.success) {
          hideModal();
          // Show success notice
          const notice = $('<div class="notice notice-success is-dismissible"><p>' +
            (allow ? 'Thank you for helping us improve PixelPulse!' : 'Your preference has been saved.') +
            '</p></div>');
          $('.wrap').first().prepend(notice);
        }
      },
      error: function () {
        // Show error notice
        const notice = $('<div class="notice notice-error is-dismissible"><p>An error occurred. Please try again.</p></div>');
        $('.wrap').first().prepend(notice);
      }
    });
  }

  // Show modal on page load
  showModal();

  // Handle button clicks
  $('#pixelpulse-allow-tracking').on('click', function () {
    handleConsent(true);
  });

  $('#pixelpulse-deny-tracking').on('click', function () {
    handleConsent(false);
  });
});