<?php

namespace PixelPulse;

use PixelPulse\includes\validation\Validator;

class AdminSettings
{
  private $validator;
  public function __construct()
  {
    add_action('admin_menu', array($this, 'addSettingsPage'));
    add_action('admin_init', array($this, 'registerSettings'));
    $this->validator = new Validator();
  }
  public function addSettingsPage()
  {
    // Check if WooCommerce is active
    if (function_exists('pixelpulse_is_woocommerce_active') && pixelpulse_is_woocommerce_active()) {
      // Add as a top-level menu item positioned directly after WooCommerce
      add_menu_page(
        esc_html__('Pixel Pulse for WooCommerce', 'pixel-pulse-for-woocommerce'),
        esc_html__('Pixel Pulse', 'pixel-pulse-for-woocommerce'),
        'manage_options',
        'pixel-manager-settings',
        array($this, 'renderSettingsPage'),
        'dashicons-analytics',
        56 // Position immediately after WooCommerce (which is at 55)
      );
    } else {
      // Fallback if WooCommerce is not active
      add_menu_page(
        esc_html__('Pixel Pulse for WooCommerce', 'pixel-pulse-for-woocommerce'),
        esc_html__('Pixel Pulse', 'pixel-pulse-for-woocommerce'),
        'manage_options',
        'pixel-manager-settings',
        array($this, 'renderSettingsPage'),
        'dashicons-analytics',
        58
      );
    }

    add_action('admin_enqueue_scripts', function () {
      wp_enqueue_style('pixel-manager-admin-styles', plugin_dir_url(__FILE__) . 'includes/css/admin-styles.css', array(), '1.0.1');
    });
  }
  public function registerSettings()
  {
    register_setting('pixel-manager-settings', 'google_analytics_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateGoogleAnalyticsId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'meta_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateMetaPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'linkedin_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateLinkedinPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'pinterest_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validatePinterestPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'microsoft_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateMicrosoftPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'tiktok_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateTiktokPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'x_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateXPixelId'),
      'default' => ''
    ));
    register_setting('pixel-manager-settings', 'clarity_pixel_id', array(
      'type' => 'string',
      'sanitize_callback' => array($this->validator, 'validateClarityPixelId'),
      'default' => ''
    ));
  }
  public function renderSettingsPage()
  {
?>
    <div class="wrap">
      <div class="pixel-manager-wrap">
        <div class="pixel-manager-header-container">
          <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'includes/images/logoPixelPulse.png'); ?>" alt="Pixel Pulse Logo" class="pixel-manager-logo">
          <h1><?php echo esc_html__('Pixel Pulse for WooCommerce', 'pixel-pulse-for-woocommerce'); ?></h1>
        </div>
        <form method="post" action="options.php" class="pixel-manager-form">
          <?php
          settings_fields('pixel-manager-settings');
          do_settings_sections('pixel-manager-settings');
          $googleAnalyticsId = get_option('google_analytics_id');
          $metaPixelId = get_option('meta_pixel_id');
          ?>
          <table class="pixel-manager-form-table">
            <tr class="pixel-manager-row">
              <th class="pixel-manager-header"><?php echo esc_html__('Google Analytics ID', 'pixel-pulse-for-woocommerce'); ?></th>
              <td>
                <input type="text" name="google_analytics_id" class="pixel-manager-input" value="<?php echo esc_attr($googleAnalyticsId); ?>" />
                <p class="pixel-manager-description">GA ID should be in the format G-XXXXXXXXX</p>
                <div class="pixel-manager-actions">
                  <a href="https://docs.google.com/document/d/1WqunkFUo0yJ231t2T_mx60n0BWxDXWNuAUUnpLuYwXI/edit?tab=t.0" class="pixel-manager-video-icon" title="Check documentation" target="_blank">
                    <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'includes/images/icon_for_document.png'); ?>" alt="Documentation Icon" />
                  </a>
                  <a href="https://www.youtube.com/watch?v=l2tNKF7Wei8" class="pixel-manager-video-icon" title="How to find your Google Analytics ID" target="_blank">
                    <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'includes/images/video_icon.png'); ?>" alt="Video Icon" />
                  </a>
                </div>
              </td>
            </tr>
            <tr class="pixel-manager-row">
              <th class="pixel-manager-header"><?php echo esc_html__('Meta Pixel ID', 'pixel-pulse-for-woocommerce'); ?></th>
              <td>
                <input type="text" name="meta_pixel_id" class="pixel-manager-input" value="<?php echo esc_attr($metaPixelId); ?>" />
                <p class="pixel-manager-description">Meta Pixel ID should be in the format 1234567890</p>
                <div class="pixel-manager-actions">
                  <a href="https://docs.google.com/document/d/1pu5p1n5DrZk6ZdX1khW8xHhMBgTB0QffXgBKtcht3So/edit?tab=t.0" class="pixel-manager-video-icon" title="Check documentation" target="_blank">
                    <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'includes/images/documentation3.png'); ?>" alt="Documentation Icon" />
                  </a>
                  <a href="https://www.youtube.com/watch?v=FiSO616WSmU" class="pixel-manager-video-icon" title="How to find your Meta Pixel ID" target="_blank">
                    <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'includes/images/videoIcon.png'); ?>" alt="Video Icon" />
                  </a>
                </div>
              </td>
            </tr>
          </table>
          <?php submit_button(null, 'primary', 'pixel-manager-submit'); ?>
        </form>
      </div>
    </div>
<?php
  }
}
