<?php
/**
 * Plugin Name: Pigee Shipping & Payments
 * Description: Handles both shipping, shipping insurance and payment gateway integrations via Pigee API for WooCommerce.
 * Version: 1.0.2
 * Requires Plugins: woocommerce
 * Author: Pigee Inc.
 * Author URI: https://www.pigeepost.com
 * Text Domain: pigee-shipping-payments
 * Domain Path: /languages
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * @package PigeeShippingPayments
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define('PIGEESHIPPINGPAYMENTS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('PIGEESHIPPINGPAYMENTS_PLUGIN_PATH', plugin_dir_path(__FILE__));

// 🔌 Declare compatibility with WooCommerce Blocks (MUST be before usage)
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
	}
} );

// 🧠 Init plugin after WooCommerce is loaded
add_action( 'plugins_loaded', 'pigeeshippingpayments_initialize_plugin', 10 );
add_action( 'plugins_loaded', 'pigeeinsurance_initialize_plugin', 11 );

/**
 * Initializes the Pigee Insurance.
 *
 * @return void
 */
function pigeeinsurance_initialize_plugin() {
	// 🧱 Insurance Checkout Block (MUST load on init, very early)	
	if (class_exists('WooCommerce')) {
        // Load insurance files
        require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'blocks/class-pigee-insurance-block.php';
        require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigee-insurance-hooks.php';
        
        // Initialize immediately
        Pigee_Insurance_Checkout_Block::init();
        Pigee_Insurance_Hooks::init();
    } else {
        error_log('❌ WooCommerce not loaded yet');
    }
}

/**
 * Initializes the Pigee Shipping Payments plugin.
 *
 * @return void
 */
function pigeeshippingpayments_initialize_plugin() {
	// Load core classes.
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/functions-pigeeshippingpayments.php';
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-api.php';
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-fulfillment.php';
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/admin/admin-display-hooks.php';
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-hooks.php';
	require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-product-sync.php';

	 // 🚚 Register shipping method
	if ( class_exists( 'WC_Shipping_Method' ) ) {
		require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-rates.php';
		require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-shipping-method.php';
		require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/admin/pigeeshippingpayments-admin.php';

		add_filter( 'woocommerce_shipping_methods', function ( $methods ) {
			$methods['pigeeshippingpayments'] = 'PigeeShippingPayments_Shipping_Method';
			return $methods;
		} );
		
		new PigeeShippingPayments_Product_Sync();  // Load product sync class		
	}

	// 💳 Register payment gateway
	if ( class_exists( 'WC_Payment_Gateway' ) ) {
		require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-order.php';
		require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'includes/class-pigeeshippingpayments-gateway.php';		

		// Register classic checkout gateway.
		add_filter( 'woocommerce_payment_gateways', function ( $gateways ) {
			$gateways[] = 'PigeeShippingPayments_Gateway';
			return $gateways;
		} );
		
		// 🧱 Register blocks payment gateway.
		add_action( 'woocommerce_blocks_loaded', function () {
			require_once PIGEESHIPPINGPAYMENTS_PLUGIN_PATH . 'blocks/class-pigeeshippingpayments-gateway-blocks.php';
			
			add_action( 'woocommerce_blocks_payment_method_type_registration', function ( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $registry ) {
				$registry->register( new PigeeShippingPayments_Gateway_Blocks() );
			} );
		} );
	}
}
