<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class PigeeShippingPayments_Product_Sync {


    public function __construct() {
		
		// Fires every time a product is created or updated in admin
		add_action('save_post_product', [$this, 'sync_product_save_hook'], 10, 3);
	
        // Fires when WC programmatically updates a product
		//add_action('woocommerce_update_product', [$this, 'sync_product_woocommerce_hook'], 10, 1);

         // Delete product
		add_action('before_delete_post', [$this, 'delete_product_from_pigee'], 10);
    }
	
	/**
     * Sync created product to Pigee
     */
	public function sync_product_save_hook($post_id, $post, $update) {
		if ($post->post_type !== 'product') return;
			$logger = wc_get_logger();
			$logger->info("save_post_product triggered for ID: $post_id (update: $update)", [
				'source' => 'pigee_product_sync'
			]);

		$product = wc_get_product($post_id);
		if (!$product) return;
		
		$payload = [
			'order_from'	=> 'wp',
            'id'          	=> $product->get_id(),
            'name'        	=> $product->get_name(),
            'shop_url' 		=> get_bloginfo('url')
        ];
		
		$api_key = get_api_key_from_shipping();
		$api_mode = get_api_mode_from_shipping();
		
		$api = new PigeeShippingPayments_API($api_key, $api_mode);
		
        // Send to API
        $api->product_sync($payload);
	}
	
    /**
     * Sync updated product to Pigee
     */
    public function sync_product_woocommerce_hook($product_id) {
		
		$logger = wc_get_logger();
		$logger->info("woocommerce_update_product triggered for ID: $product_id", [
			'source' => 'pigee_product_sync'
		]);

		
        $product = wc_get_product($product_id);
		if (!$product) {
			$logger->warning("Product not found for ID: $product_id", [
				'source' => 'pigee_product_sync'
			]);
			return;
		}
       
		$api_key = get_api_key_from_shipping();
		$api_mode = get_api_mode_from_shipping();
		
		$api = new PigeeShippingPayments_API($api_key, $api_mode);
		
        $payload = [
			'order_from'	=> 'wp',
            'id'          	=> $product->get_id(),
            'name'        	=> $product->get_name(),
            'shop_url' 		=> get_bloginfo('url')
        ];
		
		// Send to API
        $api->product_sync($payload);
    }

    /**
     * Sync product deletion
     */
    public function delete_product_from_pigee($post_id) {
        if (get_post_type($post_id) !== 'product') {
            return;
        }

		$api_key = get_api_key_from_shipping();
		$api_mode = get_api_mode_from_shipping();
		
		$api = new PigeeShippingPayments_API($api_key, $api_mode);
		
        $payload = [
			'order_from'	=> 'wp',
            'id'			=> $post_id,
            'shop_url' 		=> get_bloginfo('url')
        ];

        // Send to API
        $api->product_delete($payload);
    }
}
