<?php
/**
 * Admin order meta display and cleanup for Pigee Shipping Payments.
 *
 * Adds Pigee reference/order ID to order details,
 * adds invoice link in shipping address section,
 * and hides unwanted meta fields in admin.
 *
 * @package PigeeShippingPayments
 */

if ( ! defined( 'ABSPATH' ) ) exit; 

/**
 * Display Pigee reference ID in order details (admin).
 *
 * @param WC_Order $order The WooCommerce order object.
 * @return void
 */
add_action( 'woocommerce_admin_order_data_after_order_details', function( $order ) {
    $pigee_ref = $order->get_meta( '_pigee_order_reference' );
    $pigee_id = $order->get_meta( '_pigee_order_id' );

    if ( $pigee_ref || $pigee_id ) {
        echo '<p><strong>Pigee Ref:</strong> ' . esc_html( $pigee_ref ) . '</p>';
		
		//  Uncomment the following line to also display the Pigee Order ID in admin order details.
		/* echo '<p><strong>Pigee Order ID:</strong> ' . esc_html( $pigee_id ) . '</p>'; */
    }
} );

/**
 * Add invoice payment link in the order shipping address section (admin).
 *
 * @param WC_Order $order The WooCommerce order object.
 * @return void
 */
function add_custom_shipping_payment_link_admin($order) {
    
	$shipping_payment_link = $order->get_meta('_pigee_shipping_payment_link');
		
    if (!empty($shipping_payment_link)) {
        echo '<p><strong>Pigee Shipping Invoice:</strong><br>';
        echo '<a href="' . esc_url($shipping_payment_link) . '" target="_blank">Pay Now</a></p>';
    }
}

add_action('woocommerce_admin_order_data_after_shipping_address', 'add_custom_shipping_payment_link_admin', 10, 1);

/**
 * Hide custom meta keys from order item meta in admin.
 *
 * @param string[] $hidden_meta_keys Array of hidden keys.
 * @return string[] Modified hidden keys.
 */
function hide_custom_shipping_meta_admin($hidden_meta_keys) {
    $hidden_meta_keys[] = 'carrier_request_id';
    $hidden_meta_keys[] = 'carrier_id';
    $hidden_meta_keys[] = 'pigee_carrier_id';
    return $hidden_meta_keys;
}

add_filter('woocommerce_hidden_order_itemmeta', 'hide_custom_shipping_meta_admin');