<?php
/**
 * Gateway Blocks integration for Pigee Shipping Payments.
 *
 * @package PigeeShippingPayments
 */

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

/**
 * Class PigeeShippingPayments_Gateway_Blocks
 *
 * Provides block integration for the Pigee Shipping Payments gateway.
 */
class PigeeShippingPayments_Gateway_Blocks  extends AbstractPaymentMethodType {
    
	/**
	 * Gateway identifier.
	 *
	 * @var string
	 */
	protected $name = 'pigeeshippingpayments_gateway';

	/**
	 * Initialize gateway settings.
	 *
	 * @return void
	 */
    public function initialize() {
        $this->settings = get_option("woocommerce_{$this->name}_settings", []);
		
    }

	/**
	 * Check whether the gateway is active.
	 *
	 * @return bool True if the gateway is enabled, false otherwise.
	 */
	public function is_active() {
		return ! empty( $this->settings['enabled'] ) && 'yes' === $this->settings['enabled'];
	}
	
	/**
	 * Get registered script handles for the payment method.
	 *
	 * @return string[] List of script handles.
	 */	 
    public function get_payment_method_script_handles() {
		
		$asset_path = plugin_dir_path(__FILE__) . 'build/payment-method-pigeeshippingpayments-gateway.asset.php';
		
		$version      = null;
        $dependencies = array();
		
		if ( file_exists( $asset_path ) ) {
			$asset = include $asset_path;
			$version      = isset( $asset[ 'version' ] ) ? $asset[ 'version' ] : $version;
            $dependencies = isset( $asset[ 'dependencies' ] ) ? $asset[ 'dependencies' ] : $dependencies;
		}
	
		
		wp_register_script(
			'wc-pigeeshippingpayments-gateway-blocks',
			plugins_url( 'build/payment-method-pigeeshippingpayments-gateway.js', __FILE__ ),
			$dependencies,
            $version,
			true
		);

		return [ 'wc-pigeeshippingpayments-gateway-blocks' ];        
    }

	/**
	 * Get payment method data for blocks checkout.
	 *
	 * @return array Payment method configuration data.
	 */
    public function get_payment_method_data() {
        return [
            'title'       => $this->settings['payment_title'] ?? __('Pigee Pay', 'pigee-shipping-payments'),
            'description' => $this->settings['description'] ?? __('Pay securely with Stripe through the Pigee gateway.', 'pigee-shipping-payments'),
			'ariaLabel'   => __('Pay with Pigee', 'pigee-shipping-payments'),
			'supports'    => ['products', 'shipping'],
			'plugin_url' => PIGEESHIPPINGPAYMENTS_PLUGIN_URL
        ];
    }
}
