/**
 * Admin script for validating Pigee Shipping Payments API key.
 *
 * - Listens for blur event on API key input.
 * - Sends AJAX request to validate the API key + mode.
 * - Displays notice below the input field with success/error messages.
 *
 * @package PigeeShippingPayments
 */
 
(function($) {
	'use strict';

	$(document).ready(function() {

		const $apiKeyInput   = $('input[name="woocommerce_pigeeshippingpayments_api_key"]');
		const $apiModeSelect = $('select[name="woocommerce_pigeeshippingpayments_api_mode"]');

		let $notice = $('<div class="pigee-api-notice" style="margin-top:5px;"></div>');
		$apiKeyInput.after($notice);

		$apiKeyInput.on('blur', function() {
			const apiKey = $apiKeyInput.val();
			const apiMode = $apiModeSelect.val();

			if (!apiKey) {
				$notice.text('').hide();
				return;
			}

			$notice.text('Validating...').css('color', '#555').show();

			$.post(
				pigeeShippingPaymentsApi.ajax_url,
				{
					action: 'pigeeshippingpayments_validate_api_key',
					api_key: apiKey,
					api_mode: apiMode,
					_wpnonce: pigeeShippingPaymentsApi.nonce
				},
				function(response) {
					if (response.success) {
						$notice.text(response.data.message).css('color', 'green');
					} else {
						$notice.text(response.data.message).css('color', 'red');
					}
				}
			).fail(function() {
				$notice.text('Failed to validate. Please try again.').css('color', 'red');
			});
		});
	});
})(jQuery);
