import { decodeEntities } from '@wordpress/html-entities';

const { registerPaymentMethod } = window.wc.wcBlocksRegistry
const { getSetting } = window.wc.wcSettings

const settings = getSetting( 'payzec_data', {} )

const label = "Payzec";

const Content = () => {
    return decodeEntities( settings.description || '' )
}

registerPaymentMethod( {
    name: "payzec",
    label: settings.description || "Payzec (Credit Card)",
    content: <Content />,
    edit: <Content />,
    canMakePayment: () => true,
    ariaLabel: label,
    supports: {
        features: settings.supports,
    }
} )