<?php
/*
Plugin Name: Payzec Gateway
Plugin URI: https://payzec.com/
Description: Payzec payment gateway integration for WooCommerce
Version: 1.0.0
Author: Payzec
Author URI: https://payzec.com
License: GPL-2.0+
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
Text Domain: payzec-gateway
Domain Path: /languages
Requires at least: 5.0
Requires PHP: 7.2
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Make sure WooCommerce is active
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    require_once plugin_dir_path(__FILE__) . 'includes/class-wc-payzec-gateway.php';
    require_once plugin_dir_path(__FILE__) . 'includes/wc-payzec-gateway-functions.php';

    register_activation_hook(__FILE__, 'payzec_activation_hook');
    function payzec_activation_hook() {
        if (!get_option('payzec_token')) {
            $token = bin2hex(openssl_random_pseudo_bytes(16));
            update_option('payzec_token', $token);
        }
    }
}