<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function payzec_encrypt($data)
{
    $key = get_option('payzec_token');
    $iv = substr($key, 0, 16);
    $encryptedData = openssl_encrypt($data, 'aes-128-cbc', $key, 0, $iv);
    return urlencode(base64_encode($encryptedData));
}

function payzec_decrypt($data)
{
    $key = get_option('payzec_token');
    $iv = substr($key, 0, 16);
    $decryptedData = openssl_decrypt(base64_decode(urldecode($data)), 'aes-128-cbc', $key, 0, $iv);
    return $decryptedData;
}

function payzec_get_cart_id()
{
    $session = WC()->session->get_customer_id();
    global $wpdb;
    $table_name = $wpdb->prefix . 'woocommerce_sessions';
    $sessionData = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE session_key = %s", $session));
    $session_id = $sessionData->session_id;
    return payzec_encrypt($session_id);
}

function payzec_getsiteurl()
{
    $siteFullUrl = get_site_url();
    $siteUrl = wp_parse_url($siteFullUrl, PHP_URL_HOST);
    return $siteUrl;
}

function payzec_add_init_js()
{
    $payzec_settings = get_option('woocommerce_payzec_settings');
    $enable_pay_link = isset($payzec_settings['show_icon']) ? $payzec_settings['show_icon'] : 'no';

    if ('yes' === $enable_pay_link) {
        wp_enqueue_script('payzec-init-js', plugins_url('/js/payzec-init.js', __FILE__), array('jquery'), null, true);
        wp_localize_script('payzec-init-js', 'payzec_api', array('rest_url' => esc_url_raw(rest_url('payzec/v1/user-data')), 'nonce' => wp_create_nonce('wp_rest'), 'site_url' => payzec_getsiteurl()));
    }
}

function payzec_add_footer_html()
{

}

function payzec_get_settings()
{
    $settings = get_option('woocommerce_payzec_settings');
    return $settings;
}

function payzec_maybe_load_cart() {
    if ( version_compare( WC_VERSION, '3.6.0', '>=' ) && WC()->is_rest_api_request() ) {
        if ( empty( $_SERVER['REQUEST_URI'] ) ) {
            return;
        }

        $rest_prefix = 'payzec/v1';
        $req_uri     = esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) );

        $is_my_endpoint = ( false !== strpos( $req_uri, $rest_prefix ) );

        if ( ! $is_my_endpoint ) {
            return;
        }

        require_once WC_ABSPATH . 'includes/wc-cart-functions.php';
        require_once WC_ABSPATH . 'includes/wc-notice-functions.php';

        if ( null === WC()->session ) {
            $session_class = apply_filters( 'woocommerce_session_handler', 'WC_Session_Handler' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound

            // Prefix session class with global namespace if not already namespaced
            if ( false === strpos( $session_class, '\\' ) ) {
                $session_class = '\\' . $session_class;
            }

            WC()->session = new $session_class();
            WC()->session->init();
        }

        /**
         * For logged in customers, pull data from their account rather than the
         * session which may contain incomplete data.
         */
        if ( is_null( WC()->customer ) ) {
            if ( is_user_logged_in() ) {
                WC()->customer = new WC_Customer( get_current_user_id() );
            } else {
                WC()->customer = new WC_Customer( get_current_user_id(), true );
            }

            // Customer should be saved during shutdown.
            add_action( 'shutdown', array( WC()->customer, 'save' ), 10 );
        }

        // Load Cart.
        if ( null === WC()->cart ) {
            WC()->cart = new WC_Cart();
        }
    }

    if ( null === WC()->cart ) {
        WC()->cart = new WC_Cart();
    }

    return WC()->cart;
}

function payzec_calculate_shipping( $address = [], $userId = 0) {
    $country   = $address['country'];
    $state     = $address['state'];
    $postcode  = $address['postcode'];
    $city      = $address['city'];
    $address_1 = $address['address'];
    $address_2 = $address['address_2'];

    WC()->shipping->reset_shipping();

    if ( $postcode && WC_Validation::is_postcode( $postcode, $country ) ) {
        $postcode = wc_format_postcode( $postcode, $country );
    }

    if ( $country ) {
        WC()->customer->set_location( $country, $state, $postcode, $city );
        WC()->customer->set_shipping_location( $country, $state, $postcode, $city );
    } else {
        WC()->customer->set_billing_address_to_base();
        WC()->customer->set_shipping_address_to_base();
    }

    WC()->customer->set_calculated_shipping( true );

    $packages = [];

    $packages[0]['contents']                 = WC()->cart->get_cart();
    $packages[0]['contents_cost']            = 0;
    $packages[0]['applied_coupons']          = WC()->cart->applied_coupons;
    $packages[0]['user']['ID']               = $userId;
    $packages[0]['destination']['country']   = $country;
    $packages[0]['destination']['state']     = $state;
    $packages[0]['destination']['postcode']  = $postcode;
    $packages[0]['destination']['city']      = $city;
    $packages[0]['destination']['address']   = $address;
    $packages[0]['destination']['address_2'] = $address_2;

    foreach ( WC()->cart->get_cart() as $item ) {
        if ( $item['data']->needs_shipping() ) {
            if ( isset( $item['line_total'] ) ) {
                $packages[0]['contents_cost'] += $item['line_total'];
            }
        }
    }

    $packages = apply_filters( 'woocommerce_cart_shipping_packages', $packages );

    return WC()->shipping->calculate_shipping( $packages );
}

function payzec_overwrite_woocommerce_session_by_id($session_id, $session_key = null) {
    global $wpdb;

    // Load WooCommerce session handler
    $wc_session = WC()->session;
    $dataKeys = array_keys($wc_session->get_session_data());
    $newData = [];
    foreach ($dataKeys as $key) {
        $newData[$key] = maybe_serialize($wc_session->get($key));
    }

    // Ensure session handler is available
    if (!is_a($wc_session, 'WC_Session_Handler')) {
        return new WP_Error('session_handler_unavailable', __('WooCommerce session handler is not available.', 'payzec-gateway'));
    }

    // Table name for WooCommerce sessions
    $table_name = $wpdb->prefix . 'woocommerce_sessions';

    // Update the session data in the database
    $result = $wpdb->update(
        $table_name,
        array('session_value' => maybe_serialize($newData)),
        array('session_id' => $session_id),
    );

    if ($result === false) {
        return new WP_Error('db_update_failed', __('Failed to update the session in the database.', 'payzec-gateway'));
    }

    return true;
}

function payzec_validate_shipping_address($address) {
    $required_fields = [
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'street' => 'Street Address',
        'city' => 'City',
        'state' => 'State',
        'zip' => 'ZIP/Postal Code',
        'country' => 'Country'
    ];

    $errors = [];

    // Check for required fields
    foreach ($required_fields as $field => $label) {
        if (empty($address[$field])) {
            $errors[] = sprintf('%s is required.', $label);
        }
    }

    // Validate email format
    if (!empty($address['email']) && !filter_var($address['email'], FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Invalid email format.';
    }

    // Validate phone (basic validation - can be enhanced based on country)
    if (!empty($address['phone'])) {
        $phone = preg_replace('/[^0-9]/', '', $address['phone']);
        if (strlen($phone) < 10) {
            $errors[] = 'Phone number must have at least 10 digits.';
        }
    }

    // Validate ZIP/Postal code (basic US format - can be enhanced for other countries)
    if (!empty($address['zip'])) {
        if (!preg_match('/^\d{5}(-\d{4})?$/', $address['zip']) && $address['country'] === 'US') {
            $errors[] = 'Invalid ZIP code format for US addresses.';
        }
    }

    // Validate country
    if (!empty($address['country'])) {
        $valid_countries = WC()->countries->get_countries();
        if (!array_key_exists($address['country'], $valid_countries)) {
            $errors[] = 'Invalid country code.';
        }
    }

    // Validate state
    if (!empty($address['state']) && !empty($address['country'])) {
        $valid_states = WC()->countries->get_states($address['country']);
        if (!empty($valid_states) && !array_key_exists($address['state'], $valid_states)) {
            $errors[] = 'Invalid state code for selected country.';
        }
    }

    return empty($errors) ? true : $errors;
}
?>