// Add CSS for bounce effect
const style = document.createElement('style');
style.innerHTML = `
@keyframes bounce {
    0%, 20%, 50%, 80%, 100% {
        transform: translateY(0);
    }
    40% {
        transform: translateY(-30px);
    }
    60% {
        transform: translateY(-15px);
    }
}

.bounce {
    animation: bounce 1s;
}
`;
document.head.appendChild(style);

let isFirstLoad = true;

jQuery(document).ready(function ($) {
    payzec_refresh();
    $('body').on('click', '.add_to_cart_button', function () {
        setTimeout(payzec_refresh, 1000); // Adjust delay as necessary
    });
});

function payzec_refresh() {
    jQuery.ajax({
        type: 'GET',
        url: payzec_api.rest_url,
        data: {
            _wpnonce: payzec_api.nonce
        },
        success: function (response) {
            window.payzecUserData = {
                loggedIn: response.logged_in,
                payzecCartId: response.payzec_cart_id,
                showIcon: response.show_payzec_icon
            };
            payzec_init();

            // Add bounce effect if not the first load
            if (!isFirstLoad) {
                const payzecElements = document.querySelectorAll('#payzec-svg-container, #payzec-popup-menu');
                payzecElements.forEach(element => {
                    element.classList.add('bounce');
                    // Remove the bounce class after animation to allow it to be re-added later
                    element.addEventListener('animationend', () => {
                        element.classList.remove('bounce');
                    }, { once: true });
                });
            } else {
                isFirstLoad = false;
            }
        },
        error: function (error) {
            console.error('Error fetching user data:', error);
        }
    });
}

function payzec_init() {
    if (window.payzecUserData.showIcon !== 'yes') return;

    window.payzec_domain = 'https://app.payzec.com';
    const { loggedIn, payzecCartId } = window.payzecUserData;

    if (payzecCartId) {
        payzecIcon();
        populatePayWithPayzecButton();
        //addFillYourAddressButton();
    }

    if (!loggedIn) {
        payzecIcon();
        //initializePayzecLoginButton();
    }
}

function removePayzecIcon() {
    // Check if element exists with the id payzec-pay-btn
}

function isUserLoggedIn() {
    return document.cookie.split(';').some(cookie => cookie.trim().startsWith('wp_woocommerce_session_'));
}

function initializePayzecLoginButton() {
    if (window.payzec_login_button) return;

    window.payzec_login_button = 1;
    const host = window.location.origin;
    const iframe = createIframe(window.payzec_domain + '/api/v1/auto-login?url=' + host, 'payzec-iframe');

    popupLoginWithPayzecButton();
    document.body.appendChild(iframe);

    const childWindow = iframe.contentWindow;
    window.addEventListener('message', (message) => {
        if (message.source !== childWindow) return;

        document.cookie = 'payzec_token=' + message.data.token + '; path=/; SameSite=None; Secure';
        window.payzec_token = message.data.token;
        popupLoginWithPayzecButton();
    });
}

function populatePayWithPayzecButton() {
    if (window.payzec_button) return;

    window.payzec_button = 1;
    const cartId = window.payzecUserData.payzecCartId;
    const site = window.location.host;

    const payButton = createButton('Pay with Payzec', 'payzec-pay-btn', '5px', 'pointer');
    document.getElementById('payzec-popup-menu').appendChild(payButton);

    payButton.addEventListener('click', () => {
        window.open(`${window.payzec_domain}/checkout?cartId=${cartId}&site=${site}`, 'Payzec', 'width=600,height=600');
    });

    const cartStatusIframe = createIframe(`${window.payzec_domain}/api/v1/trackCart?cart_id=${cartId}`, 'payzec-cartstatus-iframe');
    document.body.appendChild(cartStatusIframe);

    const childWindow = cartStatusIframe.contentWindow;
    window.addEventListener('message', (message) => {
        if (message.source !== childWindow) return;

        if (message.data) {
            window.location.href = '/payzec/order/success';
        }
    });
}

function addFillYourAddressButton() {
    if(window.add_fill_your_address_button) return;

    window.add_fill_your_address_button = 1;
    const cartId = window.payzecUserData.payzecCartId;
    const site = window.location.host;

    const addressButton = createButton('Fill Your Address', 'payzec-address-btn', '5px', 'pointer');
    document.getElementById('payzec-popup-menu').appendChild(addressButton);

    addressButton.addEventListener('click', () => {
        window.location.href = `${window.payzec_domain}/site/adress_fill?site=${site}&cartId=${cartId}`;
    });
}

function popupLoginWithPayzecButton() {
    const loginButton = createButton('Login with Payzec', 'payzec-login-btn', '5px', 'pointer', '1px solid #ddd');
    document.getElementById('payzec-popup-menu').appendChild(loginButton);

    loginButton.addEventListener('click', () => {
        const data = { userSecret: window.payzec_token };
        const xhr = new XMLHttpRequest();
        xhr.open('POST', '/rest/V1/payzec/login', true);
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.send(JSON.stringify(data));

        xhr.onreadystatechange = () => {
            if (xhr.readyState === 4) {
                const response = JSON.parse(xhr.responseText);
                if (xhr.status === 200 && response === true) {
                    window.location.href = '/customer/account/';
                } else {
                    alert(response.message);
                }
            }
        };
    });
}

function payzecIcon() {
    if (window.payzec_icon) return;

    window.payzec_icon = 1;
    const svgContainer = createSvgContainer();
    document.body.appendChild(svgContainer);

    const popupMenu = createPopupMenu();
    document.body.appendChild(popupMenu);

    svgContainer.addEventListener('click', () => {
        toggleMenu(popupMenu);
    });

    document.body.addEventListener('click', (event) => {
        if (!event.target.classList.contains('payzec-icon') && event.target.id !== 'payzec-popup-menu') {
            popupMenu.style.display = 'none';
        }
    });
}

function createIframe(src, id) {
    const iframe = document.createElement('iframe');
    iframe.setAttribute('src', src);
    iframe.style.display = 'none';
    iframe.id = id;
    return iframe;
}

function createButton(text, id, padding, cursor, borderBottom = '') {
    const button = document.createElement('div');
    button.textContent = text;
    button.id = id;
    button.style.padding = padding;
    button.style.cursor = cursor;
    if (borderBottom) {
        button.style.borderBottom = borderBottom;
    }
    return button;
}

function createSvgContainer() {
    const svgContainer = document.createElement('div');
    svgContainer.innerHTML = `<svg class='payzec-icon' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' width='60px' height='58px' viewBox='0 0 60 58' version='1.1'>
        <g class='payzec-icon' id='surface1'>
            <path class='payzec-icon' style='stroke:none;fill-rule:nonzero;fill:rgb(18.823529%,20%,99.607843%);fill-opacity:1;' d='M 35.167969 26.421875 L 18.15625 29.640625 C 17.390625 29.785156 16.847656 30.355469 16.847656 31.015625 L 16.847656 47.097656 C 16.847656 47.621094 17.195312 48.105469 17.757812 48.347656 L 34.769531 55.695312 C 35.886719 56.179688 37.222656 55.5 37.222656 54.445312 L 37.222656 27.792969 C 37.222656 26.890625 36.21875 26.21875 35.167969 26.421875 Z M 35.167969 26.421875 '/>
            <path class='payzec-icon' style='stroke:none;fill-rule:nonzero;fill:rgb(16.862745%,37.254902%,100%);fill-opacity:1;' d='M 53.089844 7.757812 C 49.714844 4.40625 45.074219 2.339844 39.960938 2.339844 L 19.171875 2.339844 C 19.152344 2.339844 19.136719 2.332031 19.117188 2.332031 L 11.078125 2.332031 C 10.480469 2.332031 10 2.820312 10 3.417969 L 10 3.644531 C 10 4.242188 10.480469 4.726562 11.078125 4.726562 L 16.28125 4.726562 C 16.191406 4.882812 16.140625 5.0625 16.140625 5.253906 L 16.140625 5.480469 C 16.140625 6.082031 16.621094 6.566406 17.21875 6.566406 L 20.558594 6.566406 C 21.230469 6.574219 21.773438 7.125 21.773438 7.800781 C 21.773438 8.140625 21.636719 8.449219 21.414062 8.671875 C 21.191406 8.894531 20.882812 9.035156 20.546875 9.035156 L 3.996094 9.035156 C 3.65625 9.035156 3.351562 9.171875 3.128906 9.394531 C 2.898438 9.628906 2.769531 9.941406 2.769531 10.269531 C 2.769531 10.949219 3.320312 11.503906 3.996094 11.503906 L 25.140625 11.503906 C 25.816406 11.503906 26.367188 12.054688 26.367188 12.738281 C 26.367188 13.078125 26.230469 13.386719 26.007812 13.609375 C 25.785156 13.832031 25.476562 13.972656 25.140625 13.972656 L 10.105469 13.972656 C 9.765625 13.972656 9.460938 14.109375 9.238281 14.332031 C 9.015625 14.558594 8.878906 14.867188 8.878906 15.207031 C 8.878906 15.886719 9.425781 16.441406 10.105469 16.441406 L 25.140625 16.441406 C 25.816406 16.441406 26.367188 16.992188 26.367188 17.671875 C 26.367188 18.015625 26.230469 18.324219 26.007812 18.546875 C 25.785156 18.769531 25.476562 18.90625 25.140625 18.90625 L 15.542969 18.90625 C 15.203125 18.90625 14.894531 19.046875 14.675781 19.269531 C 14.453125 19.496094 14.316406 19.804688 14.316406 20.140625 C 14.316406 20.824219 14.863281 21.375 15.542969 21.375 L 26.179688 21.375 C 26.277344 21.378906 26.371094 21.367188 26.460938 21.34375 L 30.019531 27.394531 L 37.21875 39.628906 L 37.378906 39.902344 L 39.960938 39.902344 C 50.367188 39.902344 58.765625 31.355469 58.636719 20.894531 C 58.578125 15.75 56.46875 11.113281 53.089844 7.757812 Z M 5.816406 4.9375 C 6.535156 4.9375 7.121094 4.351562 7.121094 3.628906 C 7.121094 2.90625 6.535156 2.320312 5.816406 2.320312 C 5.097656 2.320312 4.515625 2.90625 4.515625 3.628906 C 4.515625 4.351562 5.097656 4.9375 5.816406 4.9375 Z M 11.699219 21.347656 C 12.136719 21.25 12.492188 20.921875 12.621094 20.488281 C 12.753906 20.058594 12.640625 19.585938 12.332031 19.261719 C 12.023438 18.933594 11.5625 18.796875 11.128906 18.90625 C 10.6875 19.007812 10.335938 19.332031 10.207031 19.765625 C 10.074219 20.195312 10.183594 20.667969 10.496094 20.992188 C 10.804688 21.320312 11.265625 21.457031 11.699219 21.347656 Z M 11.699219 21.347656 '/>
        </g>
    </svg>`;
    svgContainer.style.position = 'fixed';
    svgContainer.style.bottom = '10px';
    svgContainer.style.right = '10px';
    svgContainer.id = 'payzec-svg-container';
    svgContainer.classList.add('payzec-svg-container');
    svgContainer.style.cursor = 'pointer';
    svgContainer.style.zIndex = '1000';
    return svgContainer;
}

function createPopupMenu() {
    const popupMenu = document.createElement('div');
    popupMenu.id = 'payzec-popup-menu';
    popupMenu.style.display = 'none';
    popupMenu.style.position = 'fixed';
    popupMenu.style.bottom = '75px';
    popupMenu.style.right = '10px';
    popupMenu.style.zIndex = '1000';
    popupMenu.style.backgroundColor = 'white';
    popupMenu.style.border = '1px solid #ddd';
    popupMenu.style.padding = '10px';
    popupMenu.style.boxShadow = '0 2px 5px rgba(0,0,0,.2)';
    popupMenu.style.borderRadius = '5px';
    return popupMenu;
}

function toggleMenu(menu) {
    menu.style.display = menu.style.display === 'block' ? 'none' : 'block';
}
