jQuery(document).ready(function($) {
    // Regenerate token logic
    $('#payzec_regenerate_token_button').click(function(e) {
        e.preventDefault();

        var confirmation = confirm('You will need to update your token on the Payzec dashboard. Are you sure you want to regenerate the token?');

        if (confirmation) {
            $.ajax({
                url: payzec_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'payzec_regenerate_token',
                    nonce: payzec_admin.nonce
                },
                success: function(response) {
                    if(response.success) {
                        $('#woocommerce_payzec_token').val(response.data.token);
                        alert('Token regenerated successfully!');
                    } else {
                        alert('Failed to regenerate token.');
                    }
                }
            });
        }
    });

    // Copy token logic
    $('#copy_payzec_token_button').click(function(e) {
        e.preventDefault();

        // Select the token input field
        var tokenField = $('#woocommerce_payzec_token');

        // Create a temporary textarea element to hold the token
        var tempInput = document.createElement('textarea');
        tempInput.value = tokenField.val();
        document.body.appendChild(tempInput);

        // Select and copy the text
        tempInput.select();
        document.execCommand('copy');

        // Remove the temporary element
        document.body.removeChild(tempInput);

        alert('Token copied to clipboard!');
    });
});
