<?php
/**
 * Asset helper utilities.
 *
 * @package Paypercut\Payments\Support
 */

declare(strict_types=1);

namespace Paypercut\Payments\Support;

/**
 * Simple helper for resolving asset URLs and paths.
 */
final class Assets {
	/**
	 * Prevent instantiation.
	 */
	private function __construct() {}

	/**
	 * Get a URL to an asset relative to the plugin assets directory.
	 *
	 * @param string $relative_path Relative path inside the assets directory.
	 *
	 * @return string
	 */
	public static function url( string $relative_path ): string {
		return PAYPERCUT_PAYMENTS_URL . 'assets/' . ltrim( $relative_path, '/' );
	}

	/**
	 * Get an absolute filesystem path to an asset.
	 *
	 * @param string $relative_path Relative path inside the assets directory.
	 *
	 * @return string
	 */
	public static function path( string $relative_path ): string {
		return PAYPERCUT_PAYMENTS_PATH . 'assets/' . ltrim( $relative_path, '/' );
	}
}
