<?php
/**
 * Produces webhook payloads for Paypercut webhook creation.
 *
 * @package Paypercut\Payments\Services
 */

declare(strict_types=1);

namespace Paypercut\Payments\Services;

use function get_bloginfo;
use function rest_url;

final class WebhookPayloadFactory {

	/**
	 * Build webhook creation payload.
	 *
	 * @param string   $webhook_url   The full webhook endpoint URL.
	 * @param string[] $enabled_events Array of event types to subscribe to.
	 * @param string   $event_type_name Human-readable name for the event type (e.g., "Checkout Session", "Subscription").
	 *
	 * @return array<string, mixed>
	 */
	public function build( string $webhook_url, array $enabled_events, string $event_type_name ): array {
		$site_name = get_bloginfo( 'name' );
		$webhook_name = $site_name
			? sprintf( '%s - %s', $site_name, $event_type_name )
			: sprintf( 'WooCommerce - %s', $event_type_name );

		return array(
			'enabled_events' => $enabled_events,
			'url'            => $webhook_url,
			'name'           => $webhook_name,
		);
	}

	/**
	 * Get the webhook endpoint URL.
	 *
	 * @return string
	 */
	public function get_webhook_url(): string {
		return rest_url( 'paypercut/v1/webhook/checkout-session' );
	}
}
