<?php
/**
 * Wrapper for creating refunds through Paypercut API.
 *
 * @package Paypercut\Payments\Services
 */

declare(strict_types=1);

namespace Paypercut\Payments\Services;

use Paypercut\Payments\Api\PaypercutApi;
use Paypercut\Payments\Support\Logger;
use Throwable;

final class RefundClient {
	private PaypercutApi $api;

	public function __construct( string $api_secret ) {
		$this->api = new PaypercutApi( $api_secret );
	}

	/**
	 * @param array<string, mixed> $payload Refund payload to send to the API.
	 *
	 * @return array<string, mixed>
	 */
	public function create( array $payload ): array {
		try {
			$response = $this->api->create_refund( $payload );
			Logger::info( 'Paypercut refund response received.' );

			return $response;
		} catch ( Throwable $exception ) {
			Logger::error( 'Failed creating Paypercut refund.' );
			throw $exception;
		}
	}
}


