<?php
/**
 * Activation handler.
 *
 * @package Paypercut\Payments\Lifecycle
 */

declare(strict_types=1);

namespace Paypercut\Payments\Lifecycle;

use function class_exists;
use function deactivate_plugins;
use function esc_html__;
use function plugin_basename;
use function wp_die;

/**
 * Handles plugin activation concerns.
 */
final class Activator {

	/**
	 * Execute activation logic.
	 */
	public function activate(): void {
		if ( ! class_exists( 'WooCommerce' ) ) {
			deactivate_plugins( plugin_basename( PAYPERCUT_PAYMENTS_FILE ) );

			wp_die(
				esc_html__( 'Paypercut Payments requires WooCommerce to be installed and active.', 'paypercut-payments-for-woocommerce' ),
				esc_html__( 'Plugin dependency check failed', 'paypercut-payments-for-woocommerce' ),
				array(
					'back_link' => true,
				)
			);
		}
	}
}
