<?php
/**
 * Paypercut Payment Token for WooCommerce.
 *
 * @package Paypercut\Payments\Gateway
 */

declare(strict_types=1);

namespace Paypercut\Payments\Gateway;

use WC_Payment_Token_CC;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Paypercut Payment Token class.
 *
 * Extends WC_Payment_Token_CC to store Paypercut payment method tokens.
 */
class PaypercutPaymentToken extends WC_Payment_Token_CC {
	/**
	 * Token type.
	 *
	 * @var string
	 */
	protected $type = 'Paypercut_CC';

	/**
	 * Get the payment method ID (Paypercut token).
	 *
	 * @return string
	 */
	public function get_payment_method_id(): string {
		return $this->get_token();
	}

	/**
	 * Set the payment method ID (Paypercut token).
	 *
	 * @param string $payment_method_id Paypercut payment method ID.
	 * @return void
	 */
	public function set_payment_method_id( string $payment_method_id ): void {
		$this->set_token( $payment_method_id );
	}

	/**
	 * Get the display name for this payment method.
	 *
	 * @param string $deprecated Deprecated parameter.
	 * @return string
	 */
	public function get_display_name( $deprecated = '' ): string {
		$card_type = $this->get_card_type() ?: 'Card';
		$last4 = $this->get_last4() ?: '****';
		
		$display = sprintf(
			/* translators: 1: card brand 2: last 4 digits */
			__( '%1$s ending in %2$s', 'paypercut-payments-for-woocommerce' ),
			ucfirst( $card_type ),
			$last4
		);

		$expiry_month = $this->get_expiry_month();
		$expiry_year = $this->get_expiry_year();
		
		if ( $expiry_month && $expiry_year ) {
			$year_display = strlen( $expiry_year ) === 4 ? substr( $expiry_year, -2 ) : $expiry_year;
			$display .= sprintf(
				/* translators: 1: expiry month 2: expiry year */
				__( ' (expires %1$s/%2$s)', 'paypercut-payments-for-woocommerce' ),
				$expiry_month,
				$year_display
			);
		}

		return $display;
	}
}

