<?php
/**
 * Plugin Name: Paypercut Payments for WooCommerce
 * Plugin URI: https://wordpress.org/plugins/paypercut-payments
 * Description: Paypercut Payments enables WooCommerce merchants to accept online payments using Paypercut's checkout experience.
 * Version: 0.1.3
 * Requires at least: 6.6
 * Requires PHP: 7.4
 * Author: Paypercut
 * Author URI: https://paypercut.co/
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: paypercut-payments-for-woocommerce
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 * WC requires at least: 7.9
 * WC tested up to: 9.3
 *
 * @package Paypercut\Payments
 */

use Paypercut\Payments\Lifecycle\Activator;
use Paypercut\Payments\Lifecycle\Deactivator;
use Paypercut\Payments\Plugin;

defined( 'ABSPATH' ) || exit;

define( 'PAYPERCUT_PAYMENTS_VERSION', '0.1.2' );
define( 'PAYPERCUT_PAYMENTS_FILE', __FILE__ );
define( 'PAYPERCUT_PAYMENTS_PATH', plugin_dir_path( __FILE__ ) );
define( 'PAYPERCUT_PAYMENTS_URL', plugin_dir_url( __FILE__ ) );

$paypercut_payments_autoload = PAYPERCUT_PAYMENTS_PATH . 'vendor/autoload.php';

if ( file_exists( $paypercut_payments_autoload ) ) {
	require_once $paypercut_payments_autoload;
}

register_activation_hook(
	PAYPERCUT_PAYMENTS_FILE,
	static function (): void {
		if ( ! class_exists( Activator::class ) ) {
			return;
		}

		( new Activator() )->activate();
	}
);

register_deactivation_hook(
	PAYPERCUT_PAYMENTS_FILE,
	static function (): void {
		if ( ! class_exists( Deactivator::class ) ) {
			return;
		}

		( new Deactivator() )->deactivate();
	}
);

add_action(
	'before_woocommerce_init',
	static function (): void {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
				'cart_checkout_blocks',
				PAYPERCUT_PAYMENTS_FILE,
				true
			);

			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 
				'custom_order_tables', 
				PAYPERCUT_PAYMENTS_FILE, 
				true 
			);
		}
	}
);

add_action(
	'woocommerce_blocks_loaded',
	static function (): void {
		require_once PAYPERCUT_PAYMENTS_PATH . 'src/Blocks/PaypercutBlocksSupport.php';

		add_action(
			'woocommerce_blocks_payment_method_type_registration',
			static function ( $registry ): void {
				static $registered = false;
				
				if ( $registered ) {
					return;
				}
				
				if ( $registry instanceof \Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry ) {
					$registry->register( new \Paypercut\Payments\Blocks\PaypercutBlocksSupport() );
					$registered = true;
				}
			}
		);
	}
);

add_action(
	'plugins_loaded',
	static function (): void {
		if ( ! did_action( 'woocommerce_loaded' ) ) {
			return;
		}

		( new Plugin() )->boot();
	}
);