<?php
/**
 * Plugin Name: Paypercut BNPL Gateway
 * Plugin URI: https://paypercut.io
 * Description: WooCommerce payment gateway for Paypercut Buy Now Pay Later (BNPL) service. Allows customers to pay for purchases in installments.
 * Version: 1.0.1
 * Author: Paypercut
 * Author URI: https://paypercut.io
 * Text Domain: paypercut-bnpl-for-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.4
 * WC requires at least: 5.0
 * WC tested up to: 8.5
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('PAYPERCUT_BNPL_VERSION', '1.0.1');
define('PAYPERCUT_BNPL_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PAYPERCUT_BNPL_PLUGIN_URL', plugin_dir_url(__FILE__));
define('PAYPERCUT_BNPL_PLUGIN_FILE', __FILE__);

// No inline secrets. PAT is read from environment/constant outside of the plugin.

// Note: For security, tokens are read from environment. No inline secrets are kept in code.

// Check if WooCommerce is active
add_action('plugins_loaded', 'paypercut_bnpl_init');

// Declare compatibility with WooCommerce features (HPOS and Blocks)
add_action('before_woocommerce_init', function() {
    if (class_exists('\\Automattic\\WooCommerce\\Utilities\\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
});

function paypercut_bnpl_init() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'paypercut_bnpl_woocommerce_missing_notice');
        return;
    }

    // Load plugin text domain (WordPress.org hosted plugins don't need this)
    // load_plugin_textdomain('paypercut-bnpl-for-woocommerce', false, dirname(plugin_basename(__FILE__)) . '/languages');

    // Include classes (robust: support both naming patterns)
    foreach (array(
        'includes/class-paypercut-bnpl-gateway.php',
        'includes/class-paypercut-bnpl-for-woocommerce-gateway.php',
    ) as $f) { $p = PAYPERCUT_BNPL_PLUGIN_DIR . $f; if (file_exists($p)) { require_once $p; break; } }
    foreach (array(
        'includes/class-paypercut-bnpl-api.php',
        'includes/class-paypercut-bnpl-for-woocommerce-api.php',
    ) as $f) { $p = PAYPERCUT_BNPL_PLUGIN_DIR . $f; if (file_exists($p)) { require_once $p; break; } }
    foreach (array(
        'includes/class-paypercut-bnpl-admin.php',
        'includes/class-paypercut-bnpl-for-woocommerce-admin.php',
    ) as $f) { $p = PAYPERCUT_BNPL_PLUGIN_DIR . $f; if (file_exists($p)) { require_once $p; break; } }
    // Blocks integration (if available)
    foreach (array(
        'includes/class-paypercut-bnpl-blocks.php',
        'includes/class-paypercut-bnpl-for-woocommerce-blocks.php',
    ) as $f) { $p = PAYPERCUT_BNPL_PLUGIN_DIR . $f; if (file_exists($p)) { require_once $p; break; } }

    // Initialize the gateway
    add_filter('woocommerce_payment_gateways', 'paypercut_bnpl_add_gateway_class');

    // Register Blocks integration if available
    add_action('woocommerce_blocks_loaded', function () {
        if (class_exists('Automattic\\WooCommerce\\Blocks\\Payments\\Integrations\\AbstractPaymentMethodType') && class_exists('Paypercut_BNPL_Blocks_Support')) {
            add_action('woocommerce_blocks_payment_method_type_registration', function( $registry ) {
                $registry->register( new Paypercut_BNPL_Blocks_Support() );
            } );
        }
    });

    // Initialize admin class (guard if class exists)
    if (class_exists('Paypercut_BNPL_Admin')) {
        new Paypercut_BNPL_Admin();
    }
}

function paypercut_bnpl_woocommerce_missing_notice() {
    echo '<div class="error"><p><strong>' . esc_html__('Paypercut BNPL Gateway requires WooCommerce to be installed and active.', 'paypercut-bnpl-for-woocommerce') . '</strong></p></div>';
}

function paypercut_bnpl_add_gateway_class($gateways) {
    $gateways[] = 'Paypercut_BNPL_Gateway';
    return $gateways;
}

// Activation hook
register_activation_hook(__FILE__, 'paypercut_bnpl_activate');

function paypercut_bnpl_activate() {
    // Check if WooCommerce is active
    if (!class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(esc_html__('Paypercut BNPL Gateway requires WooCommerce to be installed and active.', 'paypercut-bnpl-for-woocommerce'));
    }
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'paypercut_bnpl_deactivate');

function paypercut_bnpl_deactivate() {
    // Clean up any scheduled events or temporary data
}

// Add settings link to plugin page
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'paypercut_bnpl_add_settings_link');

function paypercut_bnpl_add_settings_link($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=paypercut_bnpl') . '">' . __('Settings', 'paypercut-bnpl-for-woocommerce') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}

