<?php
/**
 * Blocks integration for Paypercut BNPL
 */

if (!defined('ABSPATH')) {
	exit;
}

// Only load if WooCommerce Blocks classes exist
if (class_exists('\\Automattic\\WooCommerce\\Blocks\\Payments\\Integrations\\AbstractPaymentMethodType')) {
	class Paypercut_BNPL_Blocks_Support extends \Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType {
		/** @var string */
		protected $name = 'paypercut_bnpl';

		/** @var array */
		protected $settings = array();

		public function initialize() {
			// Load gateway settings directly from WooCommerce options
			$this->settings = get_option('woocommerce_paypercut_bnpl_settings', array());
		}

		/**
		 * Blocks requires the payment method name.
		 * @return string
		 */
		public function get_name() {
			return $this->name;
		}

		public function is_active() {
			$enabled = isset($this->settings['enabled']) && $this->settings['enabled'] === 'yes';
			if (!$enabled) {
				return false;
			}
			// Minimal checks; full checks live inside the PHP gateway is_available()
			return true;
		}

		public function get_payment_method_script_handles() {
			// Register frontend JS for Blocks
			wp_register_script(
				'paypercut-bnpl-blocks',
				PAYPERCUT_BNPL_PLUGIN_URL . 'assets/js/blocks.js',
				array('wc-blocks-registry', 'wc-settings', 'wp-element', 'wp-i18n'),
				PAYPERCUT_BNPL_VERSION,
				true
			);

			// Provide data to JS via wcSettings under `${name}_data`
			$method_data = $this->get_payment_method_data();
			// wp_localize_script is acceptable for simple data passing
			wp_localize_script('paypercut-bnpl-blocks', 'paypercutBnplData', $method_data);

			return array('paypercut-bnpl-blocks');
		}

        public function get_payment_method_data() {
            // Load description from settings (editable by merchant)
            $title = __('Paypercut BNPL', 'paypercut-bnpl-for-woocommerce');
            $description = isset($this->settings['description']) && !empty($this->settings['description']) 
                ? $this->settings['description'] 
                : __('Split your purchase into manageable installments with Paypercut BNPL', 'paypercut-bnpl-for-woocommerce');
            $icon = PAYPERCUT_BNPL_PLUGIN_URL . 'assets/images/ppc-logo.png';

            return array(
                'title' => $title,
                'description' => $description,
                'icon' => $icon,
                'supports' => array(
                    'products' => true,
                ),
            );
        }
	}
}

?>

