( function( wp, wc ) {
	const { registerPaymentMethod } = wc.wcBlocksRegistry || {};
	if (!registerPaymentMethod) {
		return;
	}

	const settings = ( wc && wc.wcSettings && wc.wcSettings.getSetting )
		? wc.wcSettings.getSetting( 'paypercut_bnpl_data', {} )
		: ( window.paypercutBnplData || {} );

    const forcedTitle = settings.title || 'Paypercut BNPL';
    const forcedDesc = settings.description || 'Split your purchase into manageable installments with Paypercut BNPL';
    const forcedIcon = settings.icon || (window.paypercutBnplData && window.paypercutBnplData.icon) || (window.paypercutAdminPayments ? window.paypercutAdminPayments.icon : '');

    registerPaymentMethod( {
        name: 'paypercut_bnpl',
        label: forcedTitle,
        ariaLabel: forcedTitle,
        content: wp.element.createElement( 'div', { className: 'paypercut-bnpl-desc', style: { display: 'flex', alignItems: 'center', gap: '8px' } }, [
            forcedIcon ? wp.element.createElement('img', { src: forcedIcon, alt: 'Paypercut', style: { height: '20px' } }) : null,
            wp.element.createElement('span', null, forcedDesc)
        ] ),
        edit: wp.element.createElement( 'div', { className: 'paypercut-bnpl-desc', style: { display: 'flex', alignItems: 'center', gap: '8px' } }, [
            forcedIcon ? wp.element.createElement('img', { src: forcedIcon, alt: 'Paypercut', style: { height: '20px' } }) : null,
            wp.element.createElement('span', null, forcedDesc)
        ] ),
		canMakePayment: () => true,
		supports: {
			features: [ 'products' ],
		},
	} );
} )( window.wp || {}, window.wc || {} );


